/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class Base64Code {
    private static final byte[] DECODE_TABLE;
    private static final byte[] ENCODE_TABLE;

    public static final byte[] base64Encode(byte[] byteData) {
        int iSrcIdx;
        if (byteData == null) {
            return null;
        }
        byte[] byteDest = new byte[(byteData.length + 2) / 3 * 4];
        int iDestIdx = 0;
        for (iSrcIdx = 0; iSrcIdx < byteData.length - 2; iSrcIdx += 3) {
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] >>> 2 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] >>> 4 & 0xF | byteData[iSrcIdx] << 4 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 2] >>> 6 & 3 | byteData[iSrcIdx + 1] << 2 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 2] & 0x3F);
        }
        if (iSrcIdx < byteData.length) {
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] >>> 2 & 0x3F);
            if (iSrcIdx < byteData.length - 1) {
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] >>> 4 & 0xF | byteData[iSrcIdx] << 4 & 0x3F);
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] << 2 & 0x3F);
            } else {
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] << 4 & 0x3F);
            }
        }
        for (iSrcIdx = 0; iSrcIdx < iDestIdx; ++iSrcIdx) {
            byteDest[iSrcIdx] = byteDest[iSrcIdx] < 26 ? (int)(byteDest[iSrcIdx] + 65) : (byteDest[iSrcIdx] < 52 ? (int)(byteDest[iSrcIdx] + 97 - 26) : (byteDest[iSrcIdx] < 62 ? (int)(byteDest[iSrcIdx] + 48 - 52) : (byteDest[iSrcIdx] < 63 ? 43 : 47)));
        }
        while (iSrcIdx < byteDest.length) {
            byteDest[iSrcIdx] = 61;
            ++iSrcIdx;
        }
        return byteDest;
    }

    public static final String base64Encode(String strInput) {
        if (strInput == null) {
            return null;
        }
        return Base64Code.base64Encode(strInput, "GBK");
    }

    public static final String base64Encode(String strInput, String charSet) {
        if (strInput == null) {
            return null;
        }
        String strOutput = null;
        byte[] byteData = new byte[strInput.length()];
        try {
            byteData = strInput.getBytes(charSet);
            strOutput = new String(Base64Code.base64Encode(byteData), charSet);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return strOutput;
    }

    public static final String base64Encode(InputStream in, String charSet) {
        try {
            int c;
            byte[] buff = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            while ((c = in.read(buff, 0, 1024)) != -1) {
                out.write(buff, 0, c);
            }
            in.close();
            out.flush();
            byte[] tmp2 = Base64Code.base64Encode(out.toByteArray());
            out.close();
            return new String(tmp2, charSet);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static byte[] base64Decode(byte[] base64Data) {
        if (base64Data == null) {
            return null;
        }
        if (base64Data.length == 0) {
            return new byte[0];
        }
        if (base64Data.length % 4 != 0) {
            throw new IllegalArgumentException("\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u957f\u5ea6\u4e3a\uff1a" + base64Data.length);
        }
        byte[] result = null;
        int groupCount = base64Data.length / 4;
        int lastData = base64Data.length;
        while (base64Data[lastData - 1] == 61) {
            if (--lastData != 0) continue;
            return new byte[0];
        }
        result = new byte[lastData - groupCount];
        int temp = 0;
        int resultIndex = 0;
        int dataIndex = 0;
        while (dataIndex + 4 < base64Data.length) {
            temp = DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        temp = 0;
        int j = 0;
        while (dataIndex < base64Data.length) {
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex]];
            ++dataIndex;
            ++j;
        }
        while (j < 4) {
            temp <<= 6;
            ++j;
        }
        result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
        if (base64Data[dataIndex - 2] != 61) {
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
        }
        if (base64Data[dataIndex - 1] != 61) {
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        return result;
    }

    public static final String base64Decode(String strInput) {
        if (strInput == null) {
            return null;
        }
        return Base64Code.base64Decode(strInput, "GBK");
    }

    public static final String base64Decode(String strInput, String charSet) {
        if (strInput == null) {
            return null;
        }
        String strOutput = null;
        byte[] byteData = new byte[strInput.length()];
        try {
            byteData = strInput.getBytes(charSet);
            strOutput = new String(Base64Code.base64Decode(byteData), charSet);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return strOutput;
    }

    public static final String base64Decode(InputStream in, String charSet) {
        try {
            int c;
            byte[] buff = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            while ((c = in.read(buff, 0, 1024)) != -1) {
                out.write(buff, 0, c);
            }
            in.close();
            out.flush();
            byte[] tmp2 = Base64Code.base64Decode(out.toByteArray());
            out.close();
            return new String(tmp2, charSet);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String Encode(String para) {
        Base64Code base64 = new Base64Code();
        String ret = Base64Code.base64Encode(para);
        return ret;
    }

    public static String Decode64(String para) {
        String retStr = "";
        Base64Code base64 = new Base64Code();
        try {
            retStr = Base64Code.base64Decode(para);
        }
        catch (Exception e) {
            retStr = "ERROR";
            e.printStackTrace();
        }
        return retStr;
    }

    static {
        int c;
        DECODE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
        ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        int index = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Code.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Code.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Code.ENCODE_TABLE[index++] = (byte)c;
        }
        Base64Code.ENCODE_TABLE[index++] = 43;
        Base64Code.ENCODE_TABLE[index++] = 47;
        for (int i = 0; i < 64; ++i) {
            Base64Code.DECODE_TABLE[Base64Code.ENCODE_TABLE[i]] = (byte)i;
        }
    }
}

