/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import com.abc.pay.client.Base64;
import com.abc.pay.client.MerchantPara;
import com.abc.pay.client.TrxException;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class CertHelper {
    public static void bindMerchantCertificateByFile(MerchantPara para, ArrayList<String> tCertFileList, ArrayList<String> tCertPasswordList) throws TrxException {
        if (tCertFileList.size() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        if (tCertPasswordList.size() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        if (tCertFileList.size() != tCertPasswordList.size()) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u6216\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef, \u6570\u91cf\u4e0d\u5339\u914d\uff01");
        }
        int size = tCertFileList.size();
        String errMessage = "";
        ArrayList<String> merchantCertificateList = new ArrayList<String>();
        ArrayList<Object> merchantKeyList = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            String err;
            KeyStore tKeyStore = null;
            FileInputStream tIn = null;
            String tMerchantCertFileName = tCertFileList.get(i);
            String tMerchantCertPassword = tCertPasswordList.get(i);
            try {
                tIn = new FileInputStream(tMerchantCertFileName);
                tKeyStore = KeyStore.getInstance("PKCS12", new Provider().getName());
                tKeyStore.load(tIn, tMerchantCertPassword.toCharArray());
            }
            catch (Exception e) {
                String err2;
                e.printStackTrace();
                errMessage = err2 = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u8def\u5f84\u3001\u6587\u4ef6\u540d\u4ee5\u53ca\u5bc6\u7801\u662f\u5426\u6b63\u786e, %s", i + 1, e.toString());
                if (tIn == null) continue;
                try {
                    tIn.close();
                }
                catch (Exception exception) {}
                continue;
            }
            Certificate tCert = null;
            String tAliases = "";
            String iMerchantCertificate = "";
            String iMerchantID = (String)para.getMerchantIDList().get(i);
            try {
                Enumeration<String> e = tKeyStore.aliases();
                if (e.hasMoreElements()) {
                    tAliases = e.nextElement();
                }
                tCert = tKeyStore.getCertificate(tAliases);
                Base64 tBase64 = new Base64();
                iMerchantCertificate = tBase64.encode(tCert.getEncoded());
            }
            catch (Exception e) {
                errMessage = err = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e\uff0c%s", i + 1, e.toString());
                continue;
            }
            merchantCertificateList.add(iMerchantCertificate);
            try {
                X509Certificate tX509Cert = (X509Certificate)tCert;
                tX509Cert.checkValidity();
            }
            catch (Exception e) {
                errMessage = err = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u8fc7\u671f\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u6709\u6548\u671f, %s", i + 1, e.toString());
                continue;
            }
            PrivateKey iMerchantKey = null;
            try {
                iMerchantKey = (PrivateKey)tKeyStore.getKey(tAliases, tMerchantCertPassword.toCharArray());
            }
            catch (Exception e) {
                String err3;
                errMessage = err3 = String.format("\u7b2c%d\u4e2a\u5546\u6237\u79c1\u94a5\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u79c1\u94a5, %s", i + 1, e.toString());
                merchantKeyList.add(new Object());
                continue;
            }
            merchantKeyList.add(iMerchantKey);
        }
        para.setMerchantCertificateList(merchantCertificateList);
        para.setMerchantKeyList(merchantKeyList);
        if (!errMessage.equals("")) {
            throw new TrxException("1305", "\u8bfb\u53d6\u5546\u6237\u8bc1\u4e66\u65f6\u5931\u8d25", errMessage);
        }
    }

    public static void bindMerchantCertificate(MerchantPara para, ArrayList<byte[]> tCertFileList, ArrayList<String> tCertPasswordList) throws TrxException {
        if (tCertFileList.size() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        if (tCertPasswordList.size() == 0) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        if (tCertFileList.size() != tCertPasswordList.size()) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u5546\u6237\u8bc1\u4e66\u50a8\u5b58\u76ee\u5f55\u6863\u540d[MerchantCertFile]\u6216\u5546\u6237\u79c1\u94a5\u52a0\u5bc6\u5bc6\u7801[MerchantCertPassword]\u914d\u7f6e\u9519\u8bef\uff01");
        }
        int size = tCertFileList.size();
        String errMessage = "";
        ArrayList<String> merchantCertificateList = new ArrayList<String>();
        ArrayList<Object> merchantKeyList = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            String err;
            boolean flag = false;
            KeyStore tKeyStore = null;
            ByteArrayInputStream bais = null;
            byte[] tMerchantCertFile = tCertFileList.get(i);
            String tMerchantCertPassword = tCertPasswordList.get(i);
            try {
                bais = new ByteArrayInputStream(tMerchantCertFile);
                tKeyStore = KeyStore.getInstance("PKCS12", new Provider().getName());
                tKeyStore.load(bais, tMerchantCertPassword.toCharArray());
            }
            catch (Exception e) {
                String err2;
                e.printStackTrace();
                errMessage = err2 = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u8def\u5f84\u3001\u6587\u4ef6\u540d\u4ee5\u53ca\u5bc6\u7801\u662f\u5426\u6b63\u786e, %s", i + 1, e.toString());
                if (bais == null) continue;
                try {
                    bais.close();
                }
                catch (Exception exception) {}
                continue;
            }
            Certificate tCert = null;
            String tAliases = "";
            String iMerchantCertificate = "";
            String iMerchantID = (String)para.getMerchantIDList().get(i);
            try {
                Enumeration<String> e = tKeyStore.aliases();
                if (e.hasMoreElements()) {
                    tAliases = e.nextElement();
                }
                tCert = tKeyStore.getCertificate(tAliases);
                Base64 tBase64 = new Base64();
                iMerchantCertificate = tBase64.encode(tCert.getEncoded());
            }
            catch (Exception e) {
                errMessage = err = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e\uff0c%s", i + 1, e.toString());
                continue;
            }
            merchantCertificateList.add(iMerchantCertificate);
            try {
                X509Certificate tX509Cert = (X509Certificate)tCert;
                tX509Cert.checkValidity();
            }
            catch (Exception e) {
                errMessage = err = String.format("\u7b2c%d\u4e2a\u8bc1\u4e66\u8fc7\u671f\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u6709\u6548\u671f, %s", i + 1, e.toString());
                continue;
            }
            PrivateKey iMerchantKey = null;
            try {
                iMerchantKey = (PrivateKey)tKeyStore.getKey(tAliases, tMerchantCertPassword.toCharArray());
            }
            catch (Exception e) {
                String err3;
                errMessage = err3 = String.format("\u7b2c%d\u4e2a\u5546\u6237\u79c1\u94a5\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u79c1\u94a5, %s", i + 1, e.toString());
                merchantKeyList.add(new Object());
                continue;
            }
            merchantKeyList.add(iMerchantKey);
        }
        para.setMerchantCertificateList(merchantCertificateList);
        para.setMerchantKeyList(merchantKeyList);
        if (!errMessage.equals("")) {
            throw new TrxException("1305", "\u8bfb\u53d6\u5546\u6237\u8bc1\u4e66\u65f6\u5931\u8d25", errMessage);
        }
    }
}

