/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DataVerifier {
    public static boolean isValidDate(String aString) {
        boolean tResult = false;
        if (aString.length() != 10) {
            return false;
        }
        if (aString.charAt(4) != '/' || aString.charAt(7) != '/') {
            return false;
        }
        try {
            int tYYYY = Integer.parseInt(aString.substring(0, 4));
            int tMM = Integer.parseInt(aString.substring(5, 7));
            int tDD = Integer.parseInt(aString.substring(8, 10));
            if (tMM < 1 || tMM > 12) {
                return false;
            }
            if (tDD < 1 || tDD > 31) {
                return false;
            }
            tResult = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return tResult;
    }

    public static boolean isValidTime(String aString) {
        boolean tResult = false;
        if (aString.length() != 8) {
            return false;
        }
        if (aString.charAt(2) != ':' || aString.charAt(5) != ':') {
            return false;
        }
        try {
            int tHH = Integer.parseInt(aString.substring(0, 2));
            int tMM = Integer.parseInt(aString.substring(3, 5));
            int tSS = Integer.parseInt(aString.substring(6, 8));
            if (tHH < 0 || tHH > 23) {
                return false;
            }
            if (tMM < 0 || tMM > 59) {
                return false;
            }
            if (tSS < 0 || tSS > 59) {
                return false;
            }
            tResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tResult;
    }

    public static boolean isValidURL(String aString) {
        return aString.indexOf("http://") == 0 || aString.indexOf("https://") == 0;
    }

    public static boolean isValidAmount(BigDecimal aAmount, int aExp) {
        boolean tResult = false;
        if (aExp >= 0) {
            String tAmountStr = aAmount.toString();
            if (tAmountStr.indexOf(46) == -1) {
                tResult = true;
            } else if (tAmountStr.indexOf(46) >= tAmountStr.length() - aExp - 1) {
                tResult = true;
            }
        }
        return tResult;
    }

    public static boolean isValidDoubleAmount(String aAmount, int precision) {
        boolean tResult = false;
        Pattern pattern = Pattern.compile("[0-9]+.?[0-9]*");
        tResult = pattern.matcher(aAmount).matches();
        if (aAmount.startsWith("0") && aAmount.lastIndexOf(".") != 1) {
            tResult = false;
        }
        if (aAmount.contains(".") && aAmount.length() - aAmount.lastIndexOf(".") > precision + 1) {
            tResult = false;
        }
        return tResult;
    }

    public static boolean isValidString(String sValue) {
        if (sValue == null) {
            return false;
        }
        return !"".equals(sValue);
    }

    public static boolean isValidString(String sValue, int len) {
        if (sValue == null) {
            return false;
        }
        return !"".equals(sValue) && sValue.length() <= len;
    }

    public static boolean isValidCertificate(String sCertificateType, String sCertificateNo) {
        if ("|I|P|S|J|K|T|F|D|W|U|R|B|A|C|E|G|H|L|M|".indexOf("|" + sCertificateType + "|") == -1) {
            return false;
        }
        if (sCertificateNo == null) {
            return false;
        }
        int len = sCertificateNo.length();
        if (!"I".equals(sCertificateType)) {
            return true;
        }
        return len == 15 || len == 18;
    }

    public static boolean isValidCertificateNo(String sCertificateNo) {
        if (sCertificateNo == null) {
            return false;
        }
        int len = sCertificateNo.length();
        return len == 15 || len == 18;
    }

    public static boolean isValidBankCardNo(String iBankCardNo) {
        if (!DataVerifier.isValidString(iBankCardNo, 20)) {
            return false;
        }
        String numeric = "1234567890";
        for (int i = 0; i < iBankCardNo.length(); ++i) {
            String character = iBankCardNo.substring(i, i + 1);
            if (numeric.indexOf(character) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNum(String num, int length) {
        if (!DataVerifier.isValidString(num, 2)) {
            return false;
        }
        String numeric = "1234567890";
        for (int i = 0; i < num.length(); ++i) {
            String character = num.substring(i, i + 1);
            if (numeric.indexOf(character) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isNum(String str) {
        String numeric = "1234567890";
        for (int i = 0; i < str.length(); ++i) {
            String character = str.substring(i, i + 1);
            if (numeric.indexOf(character) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDate8(String sDate) {
        boolean tResult = false;
        if (sDate == null) {
            return false;
        }
        if (sDate.length() != 8) {
            return false;
        }
        try {
            int tYYYY = Integer.parseInt(sDate.substring(0, 4));
            int tMM = Integer.parseInt(sDate.substring(4, 6));
            int tDD = Integer.parseInt(sDate.substring(6, 8));
            if (tMM < 1 || tMM > 12) {
                return false;
            }
            if (tDD < 1 || tDD > 31) {
                return false;
            }
            if ((tMM == 4 || tMM == 6 || tMM == 9 || tMM == 11) && tDD > 30) {
                return false;
            }
            if (tMM == 2 && (tYYYY % 4 == 0 && tYYYY % 100 != 0 || tYYYY % 400 == 0 ? tDD > 29 : tDD > 28)) {
                return false;
            }
            tResult = true;
        }
        catch (Exception e) {
            return false;
        }
        return tResult;
    }

    public static boolean isValidDateTime(String aString) {
        boolean tResult = false;
        if (aString.length() != 19) {
            return false;
        }
        if (aString.charAt(4) != '-' || aString.charAt(7) != '-' || aString.charAt(10) != ' ' || aString.charAt(13) != ':' || aString.charAt(16) != ':') {
            return false;
        }
        try {
            int tYYYY = Integer.parseInt(aString.substring(0, 4));
            int tMM = Integer.parseInt(aString.substring(5, 7));
            int tDD = Integer.parseInt(aString.substring(8, 10));
            int tHH = Integer.parseInt(aString.substring(11, 13));
            int MM = Integer.parseInt(aString.substring(14, 16));
            int tSS = Integer.parseInt(aString.substring(17, 19));
            if (tMM < 1 || tMM > 12) {
                return false;
            }
            if (tDD < 1 || tDD > 31) {
                return false;
            }
            if (tHH < 0 || tHH > 23) {
                return false;
            }
            if (MM < 0 || tMM > 59) {
                return false;
            }
            if (tSS < 0 || tSS > 59) {
                return false;
            }
            tResult = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return tResult;
    }

    public static String CheckKeyValue(LinkedHashMap dic, String key) {
        String ret = "";
        boolean pendingSeparator = false;
        Set entries = dic.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue().toString().length() != 0) continue;
            ret = entry.getKey().toString();
            break;
        }
        return ret;
    }

    public static String CheckKeyValues(LinkedHashMap dic, String key) {
        Map.Entry entry;
        String ret = "";
        Set entries = dic.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext() && (ret = DataVerifier.CheckKeyValue((LinkedHashMap)(entry = iter.next()).getValue(), key)).length() == 0) {
        }
        return ret;
    }

    public static boolean isValid(String str) {
        String numeric = "1234567890";
        if (str.length() <= 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            String character = str.substring(i, i + 1);
            if (numeric.indexOf(character) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidAccount(String aAccount) {
        boolean tResult = false;
        Pattern pattern = Pattern.compile("[0-9]*[a-z]*[A-Z]*");
        tResult = pattern.matcher(aAccount).matches();
        return tResult;
    }
}

