/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String filePath, String merchantID, String merchantCertFile, String merchantCertPassword) {
        BufferedReader br = null;
        String line = null;
        StringBuffer buf = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filePath));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("MerchantID=")) {
                    if (line.trim().length() == 11) {
                        buf.append(line).append(merchantID);
                    } else {
                        buf.append(line).append(",").append(merchantID);
                    }
                } else if (line.startsWith("MerchantCertFile=")) {
                    if (line.trim().length() == 17) {
                        buf.append(line).append(merchantCertFile);
                    } else {
                        buf.append(line).append(",").append(merchantCertFile);
                    }
                } else if (line.startsWith("MerchantCertPassword=")) {
                    if (line.trim().length() == 21) {
                        buf.append(line).append(merchantCertPassword);
                    } else {
                        buf.append(line).append(",").append(merchantCertPassword);
                    }
                } else {
                    buf.append(line);
                }
                buf.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    br = null;
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filePath, String content) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(filePath));
            bw.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    bw = null;
                }
            }
        }
    }

    public void fileAppender(String fileName, String oldContent, String content) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = null;
        StringBuilder sb = new StringBuilder();
        sb.append(content);
        while ((line = reader.readLine()) != null && line.equals(oldContent)) {
            sb.append(line);
            sb.append("\r\n");
        }
        reader.close();
        RandomAccessFile mm = new RandomAccessFile(fileName, "rw");
        mm.writeBytes(sb.toString());
        mm.close();
    }

    public byte[] readFile(String filePath) {
        File file = new File(filePath);
        byte[] fileContent = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            fileContent = new byte[(int)file.length()];
            fin.read(fileContent);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found" + e);
        }
        catch (IOException ioe) {
            System.out.println("Exception while reading the file " + ioe);
        }
        return fileContent;
    }

    public static void main(String[] args) {
        String filePath = FileUtil.class.getResource("").getPath() + "test.properties";
        FileUtil obj = new FileUtil();
        obj.write(filePath, obj.read(filePath, "AA", "BB", "CC"));
    }
}

