/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import com.abc.pay.client.LogWriter;
import com.abc.pay.client.TrxException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonResponse {
    protected String iReturnCode = "";
    public static final String RC_SUCCESS = "0000";
    protected String iErrorMessage = "";
    protected String iResponseMessage = "";

    public JsonResponse(String tResponseMessage) throws TrxException {
        this.init(tResponseMessage);
    }

    public JsonResponse(String aReturnCode, String aErrorMessage) {
        this.setReturnCode(aReturnCode);
        this.setErrorMessage(aErrorMessage);
    }

    protected JsonResponse() {
    }

    protected void init(String tResponseMessage) throws TrxException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(tResponseMessage);
        }
        catch (Exception e) {
            new LogWriter().logNewLine("\u521d\u59cb\u5316\u8fd4\u56de\u62a5\u6587\u62a5\u9519\uff1a" + e.getMessage());
        }
        JsonNode msgNode = rootNode.path("MSG");
        JsonNode messageNode = msgNode.path("Message");
        JsonNode trxResponse = messageNode.path("TrxResponse");
        String tReturnCode = trxResponse.path("ReturnCode").asText();
        if (tReturnCode == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[ReturnCode]!");
        }
        this.setReturnCode(tReturnCode.toString());
        String tErrorMessage = trxResponse.path("ErrorMessage").asText();
        if (tErrorMessage != null) {
            this.setErrorMessage(tErrorMessage.toString());
        }
        if (this.getReturnCode().equals(RC_SUCCESS)) {
            this.iResponseMessage = tResponseMessage;
        }
    }

    public boolean isSuccess() {
        return this.iReturnCode.equals(RC_SUCCESS);
    }

    public JsonResponse setReturnCode(String aReturnCode) {
        this.iReturnCode = aReturnCode.trim();
        return this;
    }

    public String getReturnCode() {
        return this.iReturnCode;
    }

    public JsonResponse setErrorMessage(String aErrorMessage) {
        this.iErrorMessage = aErrorMessage.trim();
        return this;
    }

    public String getErrorMessage() {
        return this.iErrorMessage;
    }

    public String getValue(String aTag) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(this.iResponseMessage);
        }
        catch (Exception e) {
            new LogWriter().logNewLine("\u521d\u59cb\u5316\u8fd4\u56de\u62a5\u6587\u62a5\u9519\uff1a" + e.getMessage());
        }
        JsonNode msgNode = rootNode.path("MSG");
        JsonNode messageNode = msgNode.path("Message");
        JsonNode trxResponse = messageNode.path("TrxResponse");
        String value = trxResponse.path(aTag).asText();
        return value;
    }

    public String[] getArray(String aTag) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(this.iResponseMessage);
        }
        catch (Exception e) {
            new LogWriter().logNewLine("\u521d\u59cb\u5316\u8fd4\u56de\u62a5\u6587\u62a5\u9519\uff1a" + e.getMessage());
        }
        JsonNode msgNode = rootNode.path("MSG");
        JsonNode messageNode = msgNode.path("Message");
        JsonNode trxResponse = messageNode.path("TrxResponse");
        JsonNode arrNode = trxResponse.path(aTag);
        String[] arr = new String[arrNode.size()];
        for (int j = 0; j < arrNode.size(); ++j) {
            arr[j] = arrNode.get(j).asText();
        }
        return arr;
    }

    public String getStringByTwoTags(String aTag, String bTag) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(this.iResponseMessage);
        }
        catch (Exception e) {
            new LogWriter().logNewLine("\u521d\u59cb\u5316\u8fd4\u56de\u62a5\u6587\u62a5\u9519\uff1a" + e.getMessage());
        }
        JsonNode msgNode = rootNode.path("MSG");
        JsonNode messageNode = msgNode.path("Message");
        JsonNode trxResponse = messageNode.path("TrxResponse");
        JsonNode aTagNode = trxResponse.path(aTag);
        JsonNode bTagNode = aTagNode.path(bTag);
        String value = bTagNode.toString();
        return value;
    }
}

