/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import com.abc.pay.client.HiCalendar;
import com.abc.pay.client.MerchantPara;
import com.abc.pay.client.MerchantParaFactory;
import com.abc.pay.client.MerchantParaFromFile;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.net.ssl.SSLSocketFactory;

public class MerchantConfig {
    private static ResourceBundle iResourceBundle = null;
    private static MerchantPara iPara = null;
    private static final String RESOURCE_NAME = "ConfigSource";
    private static SSLSocketFactory iSSLSocketFactory = null;
    private static MerchantConfig uniqueInstanceOf_MerchantConfig = null;

    private MerchantConfig() throws TrxException {
        MerchantConfig.bundle();
    }

    private static synchronized void syncInit() throws TrxException {
        if (uniqueInstanceOf_MerchantConfig == null) {
            uniqueInstanceOf_MerchantConfig = new MerchantConfig();
        }
    }

    public static MerchantConfig getUniqueInstance() throws TrxException {
        if (uniqueInstanceOf_MerchantConfig == null) {
            MerchantConfig.syncInit();
        }
        return uniqueInstanceOf_MerchantConfig;
    }

    public MerchantPara getPara() {
        return iPara;
    }

    private static void bundle() throws TrxException {
        try {
            iResourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[Trustpay\u5546\u6237\u7aefAPI] - \u521d\u59cb\u914d\u7f6e\u65b9\u5f0f - \u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u7aef\u914d\u7f6e\u9879\u914d\u7f6e\u6587\u4ef6");
        }
        if (iResourceBundle == null) {
            MerchantParaFromFile factory = new MerchantParaFromFile();
            iPara = ((MerchantParaFactory)factory).getMerchantPara();
        } else {
            String configSourceMethod = "";
            String configSourceClass = "";
            try {
                configSourceMethod = iResourceBundle.getString("ConfigSourceMethod").trim();
            }
            catch (Exception e) {
                throw new TrxException("1008", "\u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u7aef\u914d\u7f6e\u9879\u83b7\u53d6\u65b9\u5f0f");
            }
            if (configSourceMethod.equals("file") || configSourceMethod.equals("")) {
                MerchantParaFromFile factory = new MerchantParaFromFile();
                iPara = ((MerchantParaFactory)factory).getMerchantPara();
            } else if (configSourceMethod.equals("database")) {
                try {
                    configSourceClass = iResourceBundle.getString("ConfigSourceClass").trim();
                }
                catch (Exception e) {
                    throw new TrxException("1009", "\u65e0\u6cd5\u8bfb\u53d6\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b");
                }
                if (configSourceClass.equals("")) {
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", " - \u672a\u8bbe\u5b9a\u5b9e\u73b0\u7c7b!");
                }
                try {
                    Class<?> cl = Class.forName(configSourceClass);
                    Object o = cl.newInstance();
                    Method m = cl.getMethod("getMerchantPara", new Class[0]);
                    iPara = (MerchantPara)m.invoke(o, new Object[0]);
                }
                catch (SecurityException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (InstantiationException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (IllegalAccessException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (NoSuchMethodException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println(Util.getExceptionString(e));
                    throw new TrxException("1010", "\u5546\u6237\u7aef\u914d\u7f6e\u9879\u5b9e\u73b0\u7c7b\u672a\u8bbe\u5b9a", e.getMessage());
                }
            }
        }
    }

    public static BufferedWriter getTrxLogFile() throws TrxException {
        return MerchantConfig.getTrxLogFile("TrxLog");
    }

    public static BufferedWriter getTrxLogFile(String aFileName) throws TrxException {
        BufferedWriter tLogFile = null;
        String tFileName = "";
        try {
            HiCalendar tHiCalendar = new HiCalendar();
            tFileName = iPara.getLogPath() + System.getProperty("file.separator") + aFileName + tHiCalendar.toString(".%Y%m%d.log");
            tLogFile = new BufferedWriter(new FileWriter(tFileName, true));
        }
        catch (IOException e) {
            System.out.println(Util.getExceptionString(e));
            throw new TrxException("1004", "\u65e0\u6cd5\u5199\u5165\u4ea4\u6613\u65e5\u5fd7\u6587\u6863", " - \u7cfb\u7edf\u65e0\u6cd5\u5199\u5165\u4ea4\u6613\u65e5\u5fd7\u81f3[" + tFileName + "]\u4e2d!");
        }
        return tLogFile;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        return iSSLSocketFactory;
    }
}

