/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import com.abc.pay.client.Base64;
import com.abc.pay.client.JSON;
import com.abc.pay.client.MerchantConfig;
import com.abc.pay.client.MerchantPara;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.XMLDocument;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Signature;
import java.security.cert.Certificate;

public class SignService {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static SignService uniqueInstanceOf_SignService = null;
    private static Certificate cert = null;
    private static MerchantPara para = null;

    private static synchronized void syncInit() throws TrxException {
        if (uniqueInstanceOf_SignService == null) {
            uniqueInstanceOf_SignService = new SignService();
        }
    }

    public static SignService getUniqueInstance() throws TrxException {
        if (uniqueInstanceOf_SignService == null) {
            SignService.syncInit();
        }
        return uniqueInstanceOf_SignService;
    }

    private SignService() throws TrxException {
        try {
            para = MerchantConfig.getUniqueInstance().getPara();
            cert = para.getTrustpayCertificate();
        }
        catch (TrxException e) {
            throw new TrxException(e.getCode(), e.getMessage());
        }
    }

    public String signMessage(int i, String aMessage) throws TrxException {
        String tMessage = null;
        try {
            tMessage = this.fileSignMessage(i, aMessage);
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TrxException("1102", "\u7b7e\u540d\u4ea4\u6613\u62a5\u6587\u65f6\u53d1\u751f\u9519\u8bef - " + e.getMessage());
        }
        return tMessage.toString();
    }

    private String fileSignMessage(int i, String aMessage) throws Exception {
        Signature tSignature = null;
        String tMessage = "";
        tSignature = Signature.getInstance(SIGNATURE_ALGORITHM);
        tSignature.initSign(para.getMerchantKey(i));
        tSignature.update(aMessage.toString().getBytes("UTF-8"));
        byte[] tSigned = tSignature.sign();
        Base64 tBase64 = new Base64();
        String tSignedBase64 = tBase64.encode(tSigned);
        tMessage = "{\"Message\":" + aMessage + "," + "\"Signature-Algorithm\":" + "\"" + SIGNATURE_ALGORITHM + "\"" + "," + "\"Signature\":" + "\"" + tSignedBase64 + "\"}";
        return tMessage.toString();
    }

    private String signServerSignMessage(String aMessage) throws Exception {
        String tMessage = "";
        Socket tSocket = null;
        OutputStream tOut = null;
        BufferedReader tIn = null;
        String tSignServerIP = para.getSignServerIP();
        int tSignServerPort = Integer.parseInt(para.getSignServerPort());
        String tSignServerPass = para.getSignServerPassword();
        try {
            tSocket = new Socket(InetAddress.getByName(tSignServerIP), tSignServerPort);
            Base64 tBase64 = new Base64();
            String tData = tBase64.encode(aMessage.toString().getBytes("UTF-8"));
            StringBuffer tSignRequest = new StringBuffer("").append("<SignReq>").append("<Password>").append(tSignServerPass).append("</Password>").append("<Signature-Algorithm>").append(SIGNATURE_ALGORITHM).append("</Signature-Algorithm>").append("<Data>").append(tData).append("</Data>").append("</SignReq>\n");
            tOut = tSocket.getOutputStream();
            tOut.write(tSignRequest.toString().getBytes("iso8859-1"));
            tOut.flush();
            tIn = new BufferedReader(new InputStreamReader(tSocket.getInputStream()));
            String tLine = tIn.readLine();
            if (tLine == null) {
                throw new TrxException("1104", "\u7b7e\u540d\u670d\u52a1\u5668\u8fd4\u56de\u7b7e\u540d\u9519\u8bef", "\u65e0\u54cd\u5e94");
            }
            XMLDocument tSignedResponse = new XMLDocument(tLine);
            String tSignBase64 = "";
            if (!tSignedResponse.getValueNoNull("RC").equals("0")) {
                throw new TrxException("1104", "\u7b7e\u540d\u670d\u52a1\u5668\u8fd4\u56de\u7b7e\u540d\u9519\u8bef", "\u9519\u8bef\u4ee3\u7801[" + tSignedResponse.getValueNoNull("RC") + "]");
            }
            tSignBase64 = tSignedResponse.getValueNoNull("Signature");
            tMessage = "{\"Message\":" + aMessage + "," + "\"Signature-Algorithm\":" + "\"" + SIGNATURE_ALGORITHM + "\"" + "," + "\"Signature\":" + "\"" + tSignBase64 + "\"}";
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TrxException("1103", "\u65e0\u6cd5\u8fde\u7ebf\u7b7e\u540d\u670d\u52a1\u5668", e.getMessage());
        }
        finally {
            if (tIn != null) {
                try {
                    tIn.close();
                }
                catch (Exception exception) {}
            }
            if (tOut != null) {
                try {
                    tOut.close();
                }
                catch (Exception exception) {}
            }
            if (tSocket != null) {
                try {
                    tSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return tMessage.toString();
    }

    public XMLDocument signMessageXML(int i, XMLDocument aMessage) throws Exception {
        StringBuffer tMessage = new StringBuffer("");
        Signature tSignature = null;
        tSignature = Signature.getInstance(SIGNATURE_ALGORITHM);
        tSignature.initSign(para.getMerchantKey(i));
        tSignature.update(aMessage.toString().getBytes("UTF-8"));
        byte[] tSigned = tSignature.sign();
        Base64 tBase64 = new Base64();
        String tSignedBase64 = tBase64.encode(tSigned);
        tMessage.append("<Message>").append(aMessage.toString()).append("</Message>").append("<Signature-Algorithm>").append(SIGNATURE_ALGORITHM).append("</Signature-Algorithm>").append("<Signature>").append(tSignedBase64).append("</Signature>");
        return new XMLDocument(tMessage.toString());
    }

    public static void verifySign(JSON json, String aMessage) throws TrxException {
        String tTrxResponse = json.GetKeyValue("Message");
        if (tTrxResponse == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Message]\u6bb5\uff01");
        }
        String tAlgorithm = json.GetKeyValue("Signature-Algorithm");
        if (tAlgorithm == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature-Algorithm]\u6bb5\uff01");
        }
        String tSignBase64 = json.GetKeyValue("Signature");
        if (tSignBase64 == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature]\u6bb5\uff01");
        }
        Base64 tBase64 = new Base64();
        byte[] tSign = tBase64.decode(tSignBase64.toString());
        try {
            Signature tSignature = Signature.getInstance(tAlgorithm.toString());
            tSignature.initVerify(para.getTrustpayCertificate());
            tSignature.update(tTrxResponse.toString().getBytes("GBK"));
            if (!tSignature.verify(tSign)) {
                throw new TrxException("1302", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new TrxException("1302", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25 - " + e.getMessage());
        }
    }

    public XMLDocument verifySignXML(XMLDocument aMessage) throws TrxException {
        XMLDocument tTrxResponse = aMessage.getValue("Message");
        if (tTrxResponse == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Message]\u6bb5\uff01");
        }
        XMLDocument tAlgorithm = aMessage.getValue("Signature-Algorithm");
        if (tAlgorithm == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature-Algorithm]\u6bb5\uff01");
        }
        XMLDocument tSignBase64 = aMessage.getValue("Signature");
        if (tSignBase64 == null) {
            throw new TrxException("1301", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u4e0d\u5b8c\u6574", "\u65e0[Signature]\u6bb5\uff01");
        }
        Base64 tBase64 = new Base64();
        byte[] tSign = tBase64.decode(tSignBase64.toString());
        try {
            Signature tSignature = Signature.getInstance(tAlgorithm.toString());
            tSignature.initVerify(para.getTrustpayCertificate());
            tSignature.update(tTrxResponse.toString().getBytes("gbk"));
            boolean result = tSignature.verify(tSign);
            if (!result) {
                throw new TrxException("1302", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new TrxException("1302", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25 - " + e.getMessage());
        }
        return tTrxResponse;
    }
}

