/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client;

import com.abc.pay.client.JSON;
import com.abc.pay.client.LogWriter;
import com.abc.pay.client.MerchantConfig;
import com.abc.pay.client.MerchantPara;
import com.abc.pay.client.SignService;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public abstract class TrxRequest {
    private LogWriter iLogWriter = null;
    private String iECMerchantType = "";
    public static final String EC_MERCHANT_TYPE_EBUS = "EBUS";
    public boolean connectionFlag = false;
    private MerchantPara para = null;
    protected static final String CHARSETCODE_UTF_8 = "UTF-8";
    private String tRequestMesg = "";

    public TrxRequest(String aECMerchantType) {
        this.iECMerchantType = aECMerchantType;
        try {
            this.para = MerchantConfig.getUniqueInstance().getPara();
        }
        catch (TrxException e) {
            e.printStackTrace();
        }
    }

    public JSON postRequest() {
        return this.extendPostRequest(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSON extendPostRequest(int i) {
        String responseMessage = "";
        JSON json = null;
        SignService sign = null;
        try {
            this.iLogWriter = new LogWriter();
            this.iLogWriter.logNewLine("TrustPayClient Java V3.3.0 \u4ea4\u6613\u5f00\u59cb==========================");
            String requestMessage = this.getRequestMessage();
            requestMessage = this.composeRequestMessage(i, requestMessage);
            sign = SignService.getUniqueInstance();
            requestMessage = sign.signMessage(i, requestMessage);
            responseMessage = this.sendMessage(requestMessage);
            responseMessage = responseMessage.substring(responseMessage.indexOf("{\"MSG"), responseMessage.length());
            json = new JSON(responseMessage);
            this.iLogWriter.logNewLine("\u9a8c\u8bc1\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u54cd\u5e94\u62a5\u6587\u7684\u7b7e\u540d\uff1a");
            SignService.verifySign(json, responseMessage);
            this.iLogWriter.log("\u6b63\u786e");
        }
        catch (TrxException e) {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + e.getCode() + "], \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + "," + e.getDetailMessage() + "]");
            }
            responseMessage = "{\"ReturnCode\":\"" + e.getCode() + "\";\"ErrorMessage\":\"" + e.getDetailMessage() + "\"}";
            json = new JSON(responseMessage);
            json.setJsonString(responseMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef]    \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + "]");
            }
            responseMessage = "{\"ReturnCode\":\"1999\";\"ErrorMessage\":\"\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage() + "\"}";
            json = new JSON(responseMessage);
            json.setJsonString(responseMessage);
        }
        finally {
            if (this.iLogWriter != null && this.para.isPrintLog()) {
                this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return json;
    }

    public String genSignature(int i) throws TrxException {
        String tResponseMessage = "";
        SignService sign = null;
        try {
            this.iLogWriter = new LogWriter();
            this.iLogWriter.logNewLine("TrustPayClient Java V3.3.0 \u4ea4\u6613\u5f00\u59cb==========================");
            this.iLogWriter.logNewLine("\u68c0\u67e5\u4ea4\u6613\u8bf7\u6c42\u662f\u5426\u5408\u6cd5\uff1a");
            this.checkRequest();
            this.iLogWriter.logNewLine("\u6b63\u786e");
            this.iLogWriter.logNewLine("\u4ea4\u6613\u62a5\u6587\uff1a");
            String tRequestMessage = this.getRequestMessage();
            this.iLogWriter.logNewLine(tRequestMessage.toString());
            this.iLogWriter.logNewLine("\u5b8c\u6574\u4ea4\u6613\u62a5\u6587\uff1a");
            tRequestMessage = this.composeRequestMessage(i, tRequestMessage);
            this.iLogWriter.logNewLine(tRequestMessage.toString());
            this.iLogWriter.logNewLine("\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
            sign = SignService.getUniqueInstance();
            tRequestMessage = sign.signMessage(i, tRequestMessage);
            StringBuffer tTempStringBuffer = new StringBuffer("").append(tRequestMessage.toString());
            this.tRequestMesg = tTempStringBuffer.toString();
            this.iLogWriter.logNewLine(this.tRequestMesg);
            this.tRequestMesg = this.tRequestMesg.replace("\"", "&quot;");
            this.iLogWriter.logNewLine("\u63d0\u4ea4\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u62a5\u6587\uff1a\n" + this.tRequestMesg);
        }
        catch (TrxException e) {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + e.getCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + " - " + e.getDetailMessage() + "]");
            }
            throw new TrxException(e.getCode(), e.getMessage() + " - " + e.getDetailMessage());
        }
        catch (Exception e) {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[1999]    \u9519\u8bef\u4fe1\u606f\uff1a[\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage() + "]");
            }
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
        }
        finally {
            if (this.iLogWriter != null && this.para.isPrintLog()) {
                this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                }
                catch (Exception exception) {}
            }
        }
        return this.tRequestMesg;
    }

    protected abstract void checkRequest() throws TrxException;

    protected abstract String getRequestMessage() throws TrxException;

    private String composeRequestMessage(int i, String inputMessage) throws TrxException {
        String message = "{\"Version\":\"V3.0.0\",\"Format\":\"JSON\",\"Merchant\":{\"ECMerchantType\":\"" + this.iECMerchantType + "\",\"MerchantID\":\"" + this.para.getMerchantID(i) + "\"}," + "\"TrxRequest\":{" + inputMessage.substring(1, inputMessage.length()) + "}}";
        return message;
    }

    private String sendMessage(String inputRequest) throws TrxException {
        String inputRequestMessage = inputRequest;
        this.iLogWriter.logNewLine("\u51c6\u5907\u63d0\u4ea4\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\uff1a\n" + inputRequestMessage);
        PostMethod post = null;
        int port = Integer.parseInt(this.para.getTrustPayServerPort());
        int trustPayServerTimeout = this.getTrustPayServerTimeout(this.para.getTrustPayServerTimeout());
        String proxyIP = this.para.getProxyIP();
        String proxyPort = this.para.getProxyPort();
        String connectMethod = this.para.getTrustPayConnectMethod();
        String url = String.format("%s://%s%s%s", connectMethod, this.para.getTrustPayServerName(), "443".equals(Integer.toString(port)) ? "" : ":" + port, inputRequest.indexOf("DownloadStatement") < 0 ? this.para.getTrustPayTrxURL() : this.para.getTrustPayFileTrxURL());
        String responseMessage = "";
        try {
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setSoTimeout(trustPayServerTimeout);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(trustPayServerTimeout);
            if (!proxyIP.equals("") && !proxyPort.equals("")) {
                client.getHostConfiguration().setProxy(proxyIP, Integer.parseInt(proxyPort));
            }
            client.getHttpConnectionManager().getParams().setTcpNoDelay(true);
            client.getHttpConnectionManager().getParams().setStaleCheckingEnabled(false);
            this.iLogWriter.logNewLine("\u8bf7\u6c42\u670d\u52a1\u5668\u5730\u5740:" + url);
            post = new PostMethod(url);
            post.getParams().setCookiePolicy("ignoreCookies");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputRequestMessage.getBytes(CHARSETCODE_UTF_8));
            post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)byteArrayInputStream));
            post.setRequestHeader("Content-Type", "application/json; charset=UTF-8");
            int result = client.executeMethod((HttpMethod)post);
            this.iLogWriter.logNewLine("\u53d1\u9001\u8bf7\u6c42\u62a5\u6587\uff1a\u6210\u529f");
            responseMessage = this.getResponse(post.getResponseBodyAsStream());
            this.iLogWriter.logNewLine("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u6210\u529f\uff0cHTTP\u54cd\u5e94\u7801:[" + result + "]\uff0c\u8fd4\u56de\u62a5\u6587\uff1a\n" + responseMessage);
            if (responseMessage.indexOf("MSG") < 0) {
                throw new TrxException("1205", "\u65e0\u6cd5\u8fa8\u8bc6\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587");
            }
            if (result < 200 || result >= 400) {
                throw new TrxException("1206", "\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u6682\u65f6\u505c\u6b62");
            }
        }
        catch (TrxException e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw e;
        }
        catch (UnknownHostException e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u53d6\u5f97[" + this.para.getTrustPayServerName() + "]\u7684IP\u5730\u5740!");
        }
        catch (ConnectException e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7ebf\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u8fde\u7ebf" + this.para.getTrustPayServerName() + "\u7684" + this.para.getTrustPayServerPort() + "\u7aef\u53e3!");
        }
        catch (SocketException e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
        }
        catch (IOException e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
        }
        catch (Exception e) {
            this.iLogWriter.logNewLine(Util.getExceptionString(e));
            this.iLogWriter.logNewLine("[HTTPClient] - \u53d1\u9001\u4ea4\u6613\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return responseMessage;
    }

    private int getTrustPayServerTimeout(String trustPayServerTimeout) throws TrxException {
        try {
            return "".equals(trustPayServerTimeout) ? 300000 : Integer.parseInt(this.para.getTrustPayServerTimeout());
        }
        catch (NumberFormatException e) {
            throw new TrxException("1001", "\u5546\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u4e2d\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", "\u65e0\u6cd5\u8bfb\u53d6\u8d85\u65f6\u65f6\u95f4");
        }
    }

    private String getResponse(InputStream responseStream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(responseStream, "GBK"));
        StringBuffer stringBuffer = new StringBuffer();
        String line = "";
        while ((line = br.readLine()) != null) {
            stringBuffer.append(line);
        }
        return stringBuffer.toString();
    }
}

