/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AgentBatchPaymentRequest
extends TrxRequest {
    public LinkedHashMap agentBatch = new LinkedHashMap();
    public LinkedHashMap items = new LinkedHashMap();
    public LinkedHashMap dicRequest = new LinkedHashMap();
    public double iSumAmount = 0.0;

    public AgentBatchPaymentRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "AgentBatch");
        this.agentBatch.put("BatchNo", "");
        this.agentBatch.put("BatchDate", "");
        this.agentBatch.put("BatchTime", "");
        this.agentBatch.put("AgentCount", "");
        this.agentBatch.put("AgentAmount", "");
        this.dicRequest.put("ReceiveAccount", "");
        this.dicRequest.put("ReceiveAccName", "");
        this.dicRequest.put("CurrencyCode", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (this.agentBatch == null) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (Integer.parseInt(this.agentBatch.get("AgentCount").toString()) != this.items.size()) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u7b14\u6570(" + this.items.size() + ")\u4e0e\u6279\u6b21\u7684\u603b\u7b14\u6570(" + Integer.parseInt(this.agentBatch.get("AgentCount").toString()) + ")\u4e0d\u7b26");
        }
        if (this.items.size() > 10000) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u7684\u603b\u7b14\u6570(" + this.items.size() + ")\u8d85\u8fc7\u6700\u5927\u9650\u5236(" + 10000 + ")");
        }
        double sAgentAmount = 0.0;
        try {
            sAgentAmount = Double.parseDouble(this.agentBatch.get("AgentAmount").toString());
        }
        catch (Exception e) {
            throw new TrxException("1101", "\u6279\u91cf\u6388\u6743\u6263\u6b3e\u603b\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (sAgentAmount != this.iSumAmount) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u91d1\u989d(" + this.agentBatch.get("AgentAmount") + ")\u4e0e\u6279\u6b21\u7684\u603b\u91d1\u989d(" + this.iSumAmount + ")\u4e0d\u7b26");
        }
        if (!DataVerifier.isValidString(this.agentBatch.get("BatchNo").toString(), 30)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u53f7\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\u6216\u4e3a\u7a7a");
        }
        if (!DataVerifier.isValidDate(this.agentBatch.get("BatchDate").toString())) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidTime(this.agentBatch.get("BatchTime").toString())) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidAmount(new BigDecimal(this.agentBatch.get("AgentAmount").toString()), 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u91cf\u6388\u6743\u6263\u6b3e\u603b\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isNum(this.agentBatch.get("AgentCount").toString()) || Integer.parseInt(this.agentBatch.get("AgentCount").toString()) > 10000) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u91cf\u6388\u6743\u6263\u6b3e\u603b\u7b14\u6570\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("CurrencyCode").toString()) || !this.dicRequest.get("CurrencyCode").toString().equals("156")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5e01\u79cd\u4e0d\u5408\u6cd5");
        }
        LinkedHashMap item = new LinkedHashMap();
        Set entries = this.items.entrySet();
        for (Map.Entry entrys : entries) {
            item = (LinkedHashMap)entrys.getValue();
            Set entrie = item.entrySet();
            for (Map.Entry entry : entrie) {
                if (entry.getKey().toString().equals("SeqNo")) {
                    if (!DataVerifier.isValidString(entry.getValue().toString())) {
                        throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u660e\u7ec6\u5e8f\u53f7\u672a\u8bbe\u7f6e\uff01");
                    }
                    if (Integer.parseInt(entry.getValue().toString()) < 1 || Integer.parseInt(entry.getValue().toString()) > 10000) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff01");
                    }
                }
                if (entry.getKey().toString().equals("OrderNo") && !DataVerifier.isValidString(entry.getValue().toString(), 60)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u539f\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
                }
                if (entry.getKey().toString().equals("AgentSignNo") && !DataVerifier.isValidString(entry.getValue().toString(), 60)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u6388\u6743\u652f\u4ed8\u7b7e\u7ea6\u53f7\u4e0d\u5408\u6cd5\uff01");
                }
                if (entry.getKey().toString().equals("AgentAmount")) {
                    if (!DataVerifier.isValidString(entry.getValue().toString())) {
                        throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u672a\u8bbe\u7f6e\uff01");
                    }
                    if (!DataVerifier.isValidDoubleAmount(entry.getValue().toString(), 2)) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
                    }
                    if (Double.parseDouble(entry.getValue().toString()) <= 0.0) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
                    }
                }
                if (entry.getKey().toString().equals("CommodityType")) {
                    if (!DataVerifier.isValidString(entry.getValue().toString())) {
                        throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5546\u54c1\u79cd\u7c7b\u672a\u8bbe\u7f6e");
                    }
                    if (entry.getValue().toString().length() != 4) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5e8f\u5217\u53f7" + item.get("SeqNo").toString() + "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5");
                    }
                }
                boolean flag = false;
                if (entry.getKey().toString().equals("InstallmentMark")) {
                    if (!DataVerifier.isValidString(entry.getValue().toString(), 60)) {
                        throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5206\u671f\u6807\u8bc6\u672a\u8bbe\u7f6e");
                    }
                    if (!entry.getValue().toString().equals("1") && !entry.getValue().toString().equals("0")) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u6807\u8bc6\u4e0d\u5408\u6cd5");
                    }
                    if (entry.getValue().toString().equals("1")) {
                        flag = true;
                    }
                }
                if (entry.getKey().toString().equals("InstallmentCode") && flag && entry.getKey().toString().length() != 8) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u4ee3\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a8\u4f4d");
                }
                if (entry.getKey().toString().equals("InstallmentNum") && flag && (!DataVerifier.isNum(entry.getKey().toString()) || entry.getKey().toString().length() > 2)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u671f\u6570\u975e\u6709\u6548\u6570\u5b57\u6216\u8005\u957f\u5ea6\u8d85\u8fc72");
                }
                if (entry.getKey().toString().equals("ProductName") && !DataVerifier.isValidString(entry.getValue().toString())) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u660e\u7ec6\u4e2d\u5546\u54c1\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
                }
                if (!entry.getKey().toString().equals("IsBreakAccount")) continue;
                if (!DataVerifier.isValidString(entry.getValue().toString())) {
                    throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5");
                }
                if (entry.getValue().toString().equals("0") || entry.getValue().toString().equals("1")) continue;
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5");
            }
        }
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"AgentBatch\":";
        js = js + JSON.WriteDictionary(this.agentBatch);
        js = js + "},\"Details\":";
        js = js + JSON.WriteDictionarys(this.items);
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

