/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AgentPaymentRequest
extends TrxRequest {
    public LinkedHashMap orderitems = new LinkedHashMap();
    public LinkedHashMap dicRequest = new LinkedHashMap();
    public LinkedHashMap dicSplitAccInfo = new LinkedHashMap();

    public AgentPaymentRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "AgentPay");
        this.dicRequest.put("OrderDate", "");
        this.dicRequest.put("OrderTime", "");
        this.dicRequest.put("OrderNo", "");
        this.dicRequest.put("AgentSignNo", "");
        this.dicRequest.put("CardNo", "");
        this.dicRequest.put("CurrencyCode", "");
        this.dicRequest.put("Amount", "");
        this.dicRequest.put("ReceiverAddress", "");
        this.dicRequest.put("Fee", "");
        this.dicRequest.put("CertificateNo", "");
        this.dicRequest.put("InstallmentMark", "");
        this.dicRequest.put("InstallmentCode", "");
        this.dicRequest.put("InstallmentNum", "");
        this.dicRequest.put("CommodityType", "");
        this.dicRequest.put("PaymentLinkType", "");
        this.dicRequest.put("BuyIP", "");
        this.dicRequest.put("ExpiredDate", "");
        this.dicRequest.put("ReceiveAccount", "");
        this.dicRequest.put("ReceiveAccName", "");
        this.dicRequest.put("MerchantRemarks", "");
        this.dicRequest.put("IsBreakAccount", "");
        this.dicRequest.put("SplitAccTemplate", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (!DataVerifier.isValidDate(this.dicRequest.get("OrderDate").toString())) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidTime(this.dicRequest.get("OrderTime").toString())) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("OrderNo").toString(), 60)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("AgentSignNo").toString(), 60)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7b7e\u7ea6\u534f\u8bae\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("CurrencyCode").toString()) || !this.dicRequest.get("CurrencyCode").toString().equals("156")) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u5e01\u79cd\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("Amount").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8d26\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        BigDecimal Amount = new BigDecimal(this.dicRequest.get("Amount").toString());
        if (!DataVerifier.isValidAmount(Amount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8d26\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("CommodityType").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5");
        }
        if (this.dicRequest.get("CommodityType").toString().length() != 4) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("InstallmentMark").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5206\u671f\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        if (!this.dicRequest.get("InstallmentMark").toString().equals("1") && !this.dicRequest.get("InstallmentMark").toString().equals("0")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        if (this.dicRequest.get("InstallmentMark").toString().equals("1")) {
            if (!DataVerifier.isValidString(this.dicRequest.get("InstallmentCode").toString()) || this.dicRequest.get("InstallmentCode").toString().length() != 8) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u4ee3\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a8\u4f4d");
            }
            if (!DataVerifier.isNum(this.dicRequest.get("InstallmentNum").toString()) || this.dicRequest.get("InstallmentNum").toString().length() > 2) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u671f\u6570\u975e\u6709\u6548\u6570\u5b57\u6216\u8005\u957f\u5ea6\u8d85\u8fc72");
            }
        } else {
            this.dicRequest.remove("InstallmentCode");
            this.dicRequest.remove("InstallmentNum");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("PaymentLinkType").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u652f\u4ed8\u6e20\u9053\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("IsBreakAccount").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5");
        }
        if (!this.dicRequest.get("IsBreakAccount").toString().equals("0") && !this.dicRequest.get("IsBreakAccount").toString().equals("1")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5,\u5fc5\u987b\u586b0\u62161");
        }
        if (this.dicRequest.get("IsBreakAccount").toString().equals("0") && this.dicSplitAccInfo.size() > 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u8d26\u6807\u5fd7\u4e3a0\u65f6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5206\u8d26\u4fe1\u606f");
        }
        String tError = this.isValid();
        if (tError.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01[" + tError + "]");
        }
    }

    private String isValid() {
        int count = this.orderitems.size();
        LinkedHashMap orderitem = new LinkedHashMap();
        Set entries = this.orderitems.entrySet();
        for (Map.Entry entrys : entries) {
            orderitem = (LinkedHashMap)entrys.getValue();
            Set entrie = orderitem.entrySet();
            for (Map.Entry entry : entrie) {
                if (!entry.getKey().toString().equals("ProductName") || entry.getValue().toString().length() != 0) continue;
                return "\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a";
            }
        }
        return "";
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"OrderItems\":";
        if (this.orderitems.size() > 0) {
            js = js + JSON.WriteDictionarys(this.orderitems);
        }
        if (this.dicSplitAccInfo.size() > 0) {
            js = js + ",\"SplitAccInfoItems\":";
            js = js + JSON.WriteDictionarys(this.dicSplitAccInfo);
        }
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

