/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AlipayRequest
extends TrxRequest {
    public LinkedHashMap dicOrder = new LinkedHashMap();
    public LinkedHashMap orderitems = new LinkedHashMap();
    public LinkedHashMap dicRequest = new LinkedHashMap();
    public LinkedHashMap dicSplitAccInfo = new LinkedHashMap();

    public AlipayRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "AliPayOrderReq");
        this.dicOrder.put("PayTypeID", "");
        this.dicOrder.put("OrderDate", "");
        this.dicOrder.put("OrderTime", "");
        this.dicOrder.put("orderTimeoutDate", "");
        this.dicOrder.put("OrderNo", "");
        this.dicOrder.put("CurrencyCode", "");
        this.dicOrder.put("OrderAmount", "");
        this.dicOrder.put("Fee", "");
        this.dicOrder.put("AccountNo", "");
        this.dicOrder.put("OrderDesc", "");
        this.dicOrder.put("OrderURL", "");
        this.dicOrder.put("ReceiverAddress", "");
        this.dicOrder.put("InstallmentMark", "");
        this.dicOrder.put("InstallmentCode", "");
        this.dicOrder.put("InstallmentNum", "");
        this.dicOrder.put("BuyIP", "");
        this.dicOrder.put("ExpiredDate", "");
        this.dicOrder.put("PAYED_RETURN_URL", "");
        this.dicRequest.put("CommodityType", "");
        this.dicRequest.put("PaymentType", "");
        this.dicRequest.put("PaymentLinkType", "");
        this.dicRequest.put("UnionPayLinkType", "");
        this.dicRequest.put("ReceiveAccount", "");
        this.dicRequest.put("ReceiveAccName", "");
        this.dicRequest.put("NotifyType", "");
        this.dicRequest.put("ResultNotifyURL", "");
        this.dicRequest.put("MerchantRemarks", "");
        this.dicRequest.put("IsBreakAccount", "");
        this.dicRequest.put("SplitAccTemplate", "");
        this.dicRequest.put("LimitPay", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        String err = this.isNullCheck();
        if (err.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5,\u8981\u7d20\u4e3a\u7a7a\uff01" + err);
        }
        String error = this.isOrderValid();
        if (error.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01" + error);
        }
    }

    private String isNullCheck() {
        if (this.dicRequest.get("PaymentLinkType") == null) {
            return "\u672a\u8bbe\u5b9a\u652f\u4ed8\u6e20\u9053\uff01";
        }
        if (this.dicRequest.get("ResultNotifyURL") == null) {
            return "\u672a\u8bbe\u5b9a\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\uff01";
        }
        if (this.dicRequest.get("PaymentType") == null) {
            return "\u672a\u8bbe\u5b9a\u652f\u4ed8\u7c7b\u578b\uff01";
        }
        if (this.dicRequest.get("NotifyType") == null) {
            return "\u672a\u8bbe\u5b9a\u652f\u4ed8\u901a\u77e5\u7c7b\u578b\uff01";
        }
        if (this.dicRequest.get("CommodityType") == null) {
            return "\u672a\u8bbe\u5b9a\u5546\u54c1\u79cd\u7c7b!";
        }
        if (this.dicOrder.get("PayTypeID") == null) {
            return "\u672a\u8bbe\u5b9a\u4ea4\u6613\u7c7b\u578b!";
        }
        if (this.dicOrder.get("OrderNo") == null) {
            return "\u672a\u8bbe\u5b9a\u4ea4\u6613\u7f16\u53f7!";
        }
        if (this.dicOrder.get("OrderDate") == null) {
            return "\u672a\u8bbe\u5b9a\u8ba2\u5355\u65e5\u671f!";
        }
        if (this.dicOrder.get("OrderTime") == null) {
            return "\u672a\u8bbe\u5b9a\u8ba2\u5355\u65f6\u95f4!";
        }
        if (this.dicOrder.get("OrderAmount") == null) {
            return "\u672a\u8bbe\u5b9a\u8ba2\u5355\u91d1\u989d!";
        }
        if (this.dicOrder.get("CurrencyCode") == null) {
            return "\u672a\u8bbe\u5b9a\u4ea4\u6613\u5e01\u79cd!";
        }
        if (this.dicRequest.get("IsBreakAccount") == null) {
            return "\u672a\u8bbe\u5b9a\u5206\u8d26\u4fe1\u606f!";
        }
        return "";
    }

    private String isOrderValid() {
        if (this.dicRequest.get("PaymentType").equals("6") && this.dicRequest.get("PaymentLinkType").equals("2")) {
            if (!this.dicRequest.get("UnionPayLinkType").equals("0") && !this.dicRequest.get("UnionPayLinkType").equals("1")) {
                return "\u94f6\u8054\u8de8\u884c\u79fb\u52a8\u652f\u4ed8\u63a5\u5165\u65b9\u5f0f\u4e0d\u5408\u6cd5";
            }
        } else {
            this.dicRequest.remove("UnionPayLinkType");
        }
        if (!this.dicRequest.get("NotifyType").equals("0") && !this.dicRequest.get("NotifyType").equals("1")) {
            return "\u652f\u4ed8\u901a\u77e5\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01";
        }
        if (!DataVerifier.isValidURL(this.dicRequest.get("ResultNotifyURL").toString())) {
            return "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01";
        }
        if (this.dicRequest.get("ResultNotifyURL").toString().length() == 0) {
            return "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01";
        }
        if (this.dicRequest.get("ResultNotifyURL").toString().getBytes().length > 200) {
            return "\u652f\u4ed8\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01";
        }
        if (this.dicRequest.get("MerchantRemarks").toString().getBytes().length > 100) {
            return "\u9644\u8a00\u957f\u5ea6\u5927\u4e8e100";
        }
        if (this.dicRequest.get("CommodityType").toString().length() != 4) {
            return "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5";
        }
        String payTypeId = this.dicOrder.get("PayTypeID").toString();
        if (!(payTypeId.equals("ALI_PC") || payTypeId.equals("ALI_WAP") || payTypeId.equals("ALI_APP") || payTypeId.equals("ALI_PRECREATE") || payTypeId.equals("ALI_CREATE") || payTypeId.equals("ALI_PAY"))) {
            return "\u8bbe\u5b9a\u4ea4\u6613\u7c7b\u578b\u9519\u8bef";
        }
        if (payTypeId.equals("DividedPay")) {
            if (!this.dicOrder.get("InstallmentMark").toString().equals("1")) {
                return "\u5206\u671f\u6807\u8bc6\u4e3a\u7a7a\u6216\u8f93\u5165\u975e\u6cd5";
            }
            if (this.dicOrder.get("InstallmentCode").toString().length() != 8) {
                return "\u5206\u671f\u4ee3\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a8\u4f4d";
            }
            if (!DataVerifier.isValidNum(this.dicOrder.get("InstallmentNum").toString(), 2)) {
                return "\u5206\u671f\u671f\u6570\u975e\u6709\u6548\u6570\u5b57\u6216\u8005\u957f\u5ea6\u8d85\u8fc72";
            }
        }
        if (payTypeId.equals("ImmediatePay") || payTypeId.equals("PreAuthPay")) {
            if (this.dicOrder.get("InstallmentMark").toString().equals("1")) {
                return "\u4ea4\u6613\u7c7b\u578b\u4e3a\u76f4\u63a5\u652f\u4ed8\u6216\u9884\u6388\u6743\u652f\u4ed8\u65f6\uff0c\u5206\u671f\u6807\u8bc6\u4e0d\u5141\u8bb8\u8f93\u5165\u4e3a\u201c1\u201d";
            }
            this.dicOrder.remove("InstallmentCode");
            this.dicOrder.remove("InstallmentNum");
        }
        if (this.dicOrder.get("OrderNo").toString().length() == 0) {
            return "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (this.dicOrder.get("OrderNo").toString().getBytes().length > 60) {
            return "\u4ea4\u6613\u7f16\u53f7\u8d85\u957f";
        }
        if (!DataVerifier.isValidDate(this.dicOrder.get("OrderDate").toString())) {
            return "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5";
        }
        if (!DataVerifier.isValidTime(this.dicOrder.get("OrderTime").toString())) {
            return "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5";
        }
        if (!this.dicOrder.get("AccountNo").toString().equals("") && this.dicOrder.get("AccountNo").toString().length() < 10) {
            return "\u652f\u4ed8\u8d26\u6237\u957f\u5ea6\u4e0d\u80fd\u5c11\u4e8e10\u4f4d";
        }
        BigDecimal orderAmount = new BigDecimal(this.dicOrder.get("OrderAmount").toString());
        if (!DataVerifier.isValidAmount(orderAmount, 2)) {
            return "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5";
        }
        if (!this.dicOrder.get("CurrencyCode").toString().equals("156")) {
            return "\u8bbe\u5b9a\u4ea4\u6613\u5e01\u79cd\u9519\u8bef";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("IsBreakAccount").toString())) {
            return "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5";
        }
        if (!this.dicRequest.get("IsBreakAccount").toString().equals("0") && !this.dicRequest.get("IsBreakAccount").toString().equals("1")) {
            return "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5";
        }
        LinkedHashMap orderitem = new LinkedHashMap();
        Set entries = this.orderitems.entrySet();
        for (Map.Entry entrys : entries) {
            orderitem = (LinkedHashMap)entrys.getValue();
            Set entrie = orderitem.entrySet();
            for (Map.Entry entry : entrie) {
                if (!entry.getKey().toString().equals("ProductName") || entry.getValue().toString().length() != 0) continue;
                return "\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a";
            }
        }
        if (this.dicRequest.get("IsBreakAccount").toString().equals("0") && this.dicSplitAccInfo.size() > 0) {
            return "\u5206\u8d26\u6807\u5fd7\u4e3a0\u65f6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5206\u8d26\u4fe1\u606f";
        }
        return "";
    }

    @Override
    public String getRequestMessage() throws TrxException {
        String js = "\"Order\":";
        js = js + JSON.WriteDictionary(this.dicOrder);
        if (this.orderitems.size() > 0) {
            js = js + ",\"OrderItems\":";
            js = js + JSON.WriteDictionarys(this.orderitems);
        }
        if (this.dicSplitAccInfo.size() > 0) {
            js = js + ",\"SplitAccInfoItems\":";
            js = js + JSON.WriteDictionarys(this.dicSplitAccInfo);
        }
        js = js + "}";
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

