/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BatchRefundRequest
extends TrxRequest {
    public LinkedHashMap dic = null;
    public LinkedHashMap batchRefundRequest = new LinkedHashMap();
    public double iSumAmount = 0.0;

    public BatchRefundRequest() {
        super("EBUS");
        this.batchRefundRequest.put("TrxType", "BatchRefund");
        this.dic = new LinkedHashMap();
        this.batchRefundRequest.put("BatchNo", "");
        this.batchRefundRequest.put("BatchDate", "");
        this.batchRefundRequest.put("BatchTime", "");
        this.batchRefundRequest.put("MerRefundAccountNo", "");
        this.batchRefundRequest.put("MerRefundAccountName", "");
        this.batchRefundRequest.put("TotalCount", "");
        this.batchRefundRequest.put("TotalAmount", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (this.batchRefundRequest == null) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String totalAmount = this.batchRefundRequest.get("TotalAmount").toString();
        String totalCount = this.batchRefundRequest.get("TotalCount").toString();
        if (Integer.parseInt(totalCount) != this.dic.size()) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u7b14\u6570(" + this.dic.size() + ")\u4e0e\u6279\u6b21\u7684\u603b\u7b14\u6570(" + Integer.parseInt(this.batchRefundRequest.get("AgentCount").toString()) + ")\u4e0d\u7b26");
        }
        if (this.dic.size() > 10000) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u7684\u603b\u7b14\u6570(" + this.dic.size() + ")\u8d85\u8fc7\u6700\u5927\u9650\u5236(" + 10000 + ")");
        }
        double dTotalAmount = 0.0;
        try {
            dTotalAmount = Double.parseDouble(totalAmount);
        }
        catch (Exception e) {
            throw new TrxException("1101", "\u6279\u91cf\u9000\u6b3e\u603b\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (dTotalAmount != this.iSumAmount) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u91d1\u989d(" + this.iSumAmount + ")\u4e0e\u6279\u6b21\u7684\u603b\u91d1\u989d(" + totalAmount + ")\u4e0d\u7b26");
        }
        if (!DataVerifier.isValidString(this.batchRefundRequest.get("BatchNo").toString().trim(), 20)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u6279\u91cf\u7f16\u53f7\u672a\u8bbe\u7f6e\uff01");
        }
        if (!DataVerifier.isValidDate(this.batchRefundRequest.get("BatchDate").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidTime(this.batchRefundRequest.get("BatchTime").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValid(totalCount)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u4ea4\u6613\u603b\u7b14\u6570\u4e0d\u5408\u6cd5\uff01");
        }
        if (Integer.parseInt(totalCount) <= 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u603b\u7b14\u6570\u4e0d\u80fd\u5c0f\u4e8e1\u7b14");
        }
        if (Integer.parseInt(totalCount) > 10000) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u603b\u7b14\u6570\u4e0d\u80fd\u5927\u4e8e10000\u7b14");
        }
        if (!DataVerifier.isValidString(totalAmount)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u4ea4\u6613\u603b\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDoubleAmount(totalAmount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u603b\u91d1\u989d\u4fdd\u75592\u4f4d\u5c0f\u6570\uff01");
        }
        if (Double.parseDouble(totalAmount) <= 0.0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
        }
        LinkedHashMap item = new LinkedHashMap();
        Set entries = this.dic.entrySet();
        for (Map.Entry entrys : entries) {
            item = (LinkedHashMap)entrys.getValue();
            Set entrie = item.entrySet();
            for (Map.Entry entry : entrie) {
                if (entry.getKey().toString().equals("SeqNo")) {
                    if (!DataVerifier.isValidString(entry.getValue().toString())) {
                        throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u5e8f\u53f7\u672a\u8bbe\u7f6e\uff01");
                    }
                    if (Integer.parseInt(entry.getValue().toString()) < 1 || Integer.parseInt(entry.getValue().toString()) > 10000) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff01");
                    }
                }
                if (entry.getKey().toString().equals("OrderNo") && !DataVerifier.isValidString(entry.getValue().toString(), 60)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u539f\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
                }
                if (entry.getKey().toString().equals("NewOrderNo") && !DataVerifier.isValidString(entry.getValue().toString(), 60)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
                }
                if (entry.getKey().toString().equals("CurrencyCode")) {
                    if (!DataVerifier.isValid(entry.getValue().toString())) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5\uff01");
                    }
                    if (!entry.getValue().equals("156")) {
                        throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5\uff01");
                    }
                }
                if (!entry.getKey().toString().equals("RefundAmount")) continue;
                if (!DataVerifier.isValidString(entry.getValue().toString())) {
                    throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u672a\u8bbe\u7f6e\uff01");
                }
                if (!DataVerifier.isValidDoubleAmount(entry.getValue().toString(), 2)) {
                    throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
                }
                if (!(Double.parseDouble(entry.getValue().toString()) <= 0.0)) continue;
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u4e2d\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
            }
        }
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"OrderData\":";
        js = js + JSON.WriteDictionarys(this.dic);
        String tMessage = JSON.WriteDictionary(this.batchRefundRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

