/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.zip.GZIPInputStream;
import sun.misc.BASE64Decoder;

public class GetReceiptRequest
extends TrxRequest {
    public LinkedHashMap<String, String> receiptRequest = new LinkedHashMap();

    public GetReceiptRequest() {
        super("EBUS");
        this.receiptRequest.put("TrxType", "GetReceipt");
        this.receiptRequest.put("SubMerchantNo", "");
        this.receiptRequest.put("OrderNo", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (this.receiptRequest.get("SubMerchantNo").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u4e8c\u7ea7\u5546\u6237\u53f7\uff01");
        }
        if (this.receiptRequest.get("SubMerchantNo").toString().getBytes().length > 15) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4e8c\u7ea7\u5546\u6237\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.receiptRequest.get("OrderNo").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u672a\u8bbe\u5b9a\u4ea4\u6613\u7f16\u53f7\uff01");
        }
        if (this.receiptRequest.get("OrderNo").toString().getBytes().length > 60) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
        }
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "";
        js = JSON.WriteDictionary(this.receiptRequest);
        return js;
    }

    public void setConnectionFlag(boolean flag) {
        this.connectionFlag = flag;
    }

    public byte[] decompressFromBase64String(String str) throws TrxException {
        byte[] recByte = null;
        if (null == str || "" == str) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        ByteArrayInputStream inBytes = null;
        GZIPInputStream gzipIn = null;
        ByteArrayOutputStream outBytes = null;
        try {
            int n;
            recByte = decoder.decodeBuffer(str);
            inBytes = new ByteArrayInputStream(recByte);
            gzipIn = new GZIPInputStream(inBytes);
            outBytes = new ByteArrayOutputStream();
            byte[] results = new byte[4096];
            while ((n = gzipIn.read(results)) > 0) {
                outBytes.write(results, 0, n);
            }
            byte[] byArray = outBytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", "\u89e3\u538b\u56fe\u7247\u6d41\u5931\u8d25\uff01");
        }
        finally {
            inBytes = null;
            gzipIn = null;
            outBytes = null;
        }
    }
}

