/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;

public class OutPaymentRequest
extends TrxRequest {
    public LinkedHashMap dicRequest = new LinkedHashMap();

    public OutPaymentRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "PayForAnother");
        this.dicRequest.put("SubMerId", "");
        this.dicRequest.put("Account", "");
        this.dicRequest.put("AccountName", "");
        this.dicRequest.put("TrxAmount", "");
        this.dicRequest.put("OrderNo", "");
        this.dicRequest.put("DrawingFlag", "");
        this.dicRequest.put("Remark", "");
        this.dicRequest.put("RecBankNo", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        String err = this.isNullCheck();
        if (err.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5,\u8981\u7d20\u4e3a\u7a7a\uff01" + err);
        }
    }

    private String isNullCheck() {
        if (this.dicRequest.get("SubMerId").toString().length() == 0) {
            return "\u672a\u8bbe\u5b9a\u5b50\u5546\u6237\u7f16\u53f7!";
        }
        if (this.dicRequest.get("Account").toString().length() == 0) {
            return "\u672a\u8bbe\u5b9a\u5b50\u5546\u6237\u6536\u6b3e\u8d26\u6237!";
        }
        if (this.dicRequest.get("AccountName").toString().length() == 0) {
            return "\u672a\u8bbe\u5b9a\u5b50\u5546\u6237\u6536\u6b3e\u8d26\u6237\u540d\u79f0!";
        }
        return "";
    }

    private String isOrderValid() {
        if (this.dicRequest.get("OrderNo").toString().length() == 0) {
            return "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a";
        }
        if (this.dicRequest.get("OrderNo").toString().getBytes().length > 60) {
            return "\u4ea4\u6613\u7f16\u53f7\u8d85\u957f";
        }
        BigDecimal orderAmount = new BigDecimal(this.dicRequest.get("TrxAmount").toString());
        if (!DataVerifier.isValidAmount(orderAmount, 2)) {
            return "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5";
        }
        return "";
    }

    @Override
    public String getRequestMessage() throws TrxException {
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        return tMessage;
    }
}

