/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.Base64Code;
import com.abc.pay.client.LogWriter;
import com.abc.pay.client.MerchantConfig;
import com.abc.pay.client.SignService;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxResponse;
import com.abc.pay.client.XMLDocument;

public class PaymentResult
extends TrxResponse {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentResult(String aMessage) throws TrxException {
        super("Notify", aMessage);
        LogWriter tLogWriter = null;
        SignService sign = null;
        try {
            tLogWriter = new LogWriter();
            tLogWriter.logNewLine("TrustPayClient Java V3.3.0 \u4ea4\u6613\u5f00\u59cb==========================");
            tLogWriter.logNewLine("\u63a5\u6536\u5230\u7684\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\uff1a\n[" + aMessage + "]");
            String tMessage = Base64Code.Decode64(aMessage);
            tLogWriter.logNewLine("\u7ecf\u8fc7Base64\u89e3\u7801\u540e\u7684\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\uff1a\n[" + tMessage + "]");
            tLogWriter.logNewLine("\u9a8c\u8bc1\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u7684\u7b7e\u540d\uff1a");
            sign = SignService.getUniqueInstance();
            XMLDocument tResult = sign.verifySignXML(new XMLDocument(tMessage));
            tLogWriter.logNewLine("\u9a8c\u8bc1\u901a\u8fc7\uff01\n \u7ecf\u8fc7\u9a8c\u8bc1\u7684\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\uff1a\n[" + tResult.toString() + "]");
            this.init(tResult);
        }
        catch (TrxException e) {
            this.setReturnCode(e.getCode());
            this.setErrorMessage(e.getMessage() + "-" + e.getDetailMessage());
            tLogWriter.log("\u9a8c\u8bc1\u5931\u8d25\uff01\n");
        }
        finally {
            boolean isPrintLog = MerchantConfig.getUniqueInstance().getPara().isPrintLog();
            if (tLogWriter != null && isPrintLog) {
                tLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    tLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                }
                catch (Exception exception) {}
            }
        }
    }
}

