/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.util.LinkedHashMap;

public class PreAuthPaymentRequest
extends TrxRequest {
    public LinkedHashMap dicPaymentRequest = new LinkedHashMap();
    public LinkedHashMap dicOrder = new LinkedHashMap();

    public PreAuthPaymentRequest() {
        super("EBUS");
        this.dicPaymentRequest.put("TrxType", "PreAuthCancelConfirm");
        this.dicOrder.put("OperateType", "");
        this.dicOrder.put("OrderDate", "");
        this.dicOrder.put("OrderTime", "");
        this.dicOrder.put("OrderNo", "");
        this.dicOrder.put("OriginalOrderNo", "");
        this.dicOrder.put("CurrencyCode", "");
        this.dicOrder.put("OrderAmount", "");
        this.dicOrder.put("Fee", "");
        this.dicOrder.put("MerchantRemarks", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (this.dicOrder.get("OperateType") == null || this.dicOrder.get("OperateType").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u7c7b\u578b\u672a\u8bbe\u5b9a\uff01");
        }
        if (this.dicOrder.get("OrderNo") == null || this.dicOrder.get("OrderNo").toString().length() == 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u7f16\u53f7\u672a\u8bbe\u5b9a\uff01");
        }
        if (this.dicOrder.get("OriginalOrderNo") == null || this.dicOrder.get("OriginalOrderNo").toString().length() == 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u539f\u8ba2\u5355\u7f16\u53f7\u672a\u8bbe\u5b9a\uff01");
        }
        if (this.dicOrder.get("OrderDate") == null || this.dicOrder.get("OrderDate").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65e5\u671f\u672a\u8bbe\u5b9a\uff01");
        }
        if (this.dicOrder.get("OrderTime") == null || this.dicOrder.get("OrderTime").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65f6\u95f4\u672a\u8bbe\u5b9a\uff01");
        }
        String trxAmount = this.dicOrder.get("OrderAmount").toString();
        if (trxAmount == null || trxAmount.toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u91d1\u989d\u672a\u8bbe\u5b9a\uff01");
        }
        if (this.dicOrder.get("CurrencyCode") == null || this.dicOrder.get("CurrencyCode").toString().length() == 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u4ea4\u6613\u5e01\u79cd\u672a\u8bbe\u5b9a\uff01");
        }
        if (!this.dicOrder.get("OperateType").toString().equals("Cancel") && !this.dicOrder.get("OperateType").toString().equals("Confirm")) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicOrder.get("OrderNo").toString().length() > 60) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicOrder.get("OriginalOrderNo").toString().length() > 60) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u539f\u8ba2\u5355\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDate(this.dicOrder.get("OrderDate").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidTime(this.dicOrder.get("OrderTime").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u4e8b\u4ef6\u4e0d\u5408\u6cd5\uff01");
        }
        if (Double.parseDouble(trxAmount) <= 0.0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDoubleAmount(trxAmount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
        String fee = this.dicOrder.get("Fee").toString();
        if (!fee.equals("")) {
            if (Double.parseDouble(fee) <= 0.0) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u624b\u7eed\u8d39\u4e0d\u5408\u6cd5\uff01");
            }
            if (!DataVerifier.isValidDoubleAmount(fee, 2)) {
                throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u624b\u7eed\u8d39\u4e0d\u5408\u6cd5\uff01");
            }
        }
        if (!this.dicOrder.get("CurrencyCode").toString().equals("156")) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicOrder.get("MerchantRemarks").toString().getBytes().length > 100) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9644\u8a00\u957f\u5ea6\u4e0d\u5408\u6cd5\uff01");
        }
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"Order\":";
        js = js + JSON.WriteDictionary(this.dicOrder);
        js = js + "}";
        String tMessage = JSON.WriteDictionary(this.dicPaymentRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

