/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;

public class QuickPaymentReSend
extends TrxRequest {
    public LinkedHashMap<String, String> dicOrder = new LinkedHashMap();
    public LinkedHashMap<String, String> dicRequest = new LinkedHashMap();

    public QuickPaymentReSend() {
        super("EBUS");
        this.dicRequest.put("TrxType", "KPayResendReq");
        this.dicOrder.put("OrderNo", "");
        this.dicOrder.put("CurrencyCode", "");
        this.dicOrder.put("OrderAmount", "");
        this.dicOrder.put("OrderDate", "");
        this.dicOrder.put("OrderTime", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        String tError = this.isValid();
        if (tError.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01[" + tError + "]");
        }
    }

    public String isValid() {
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderNo").toString(), 60)) {
            return "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a\u6216\u8d85\u8fc7\u957f\u5ea6\u9650\u5236!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderAmount").toString())) {
            return "\u8ba2\u5355\u91d1\u989d\u672a\u8bbe\u5b9a!";
        }
        if (Double.parseDouble(this.dicOrder.get("OrderAmount").toString()) <= 0.0) {
            return "\u8ba2\u5355\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e\u96f6!";
        }
        if (!DataVerifier.isValidAmount(new BigDecimal(this.dicOrder.get("OrderAmount").toString()), 2)) {
            return "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidDate(this.dicOrder.get("OrderDate").toString())) {
            return "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidTime(this.dicOrder.get("OrderTime").toString())) {
            return "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("CurrencyCode").toString())) {
            return "\u4ea4\u6613\u5e01\u79cd\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicOrder.get("CurrencyCode").toString().equals("156")) {
            return "\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5!";
        }
        return "";
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"Order\":";
        js = js + JSON.WriteDictionary(this.dicOrder);
        js = js + "}";
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

