/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class QuickPaymentRequest
extends TrxRequest {
    public LinkedHashMap dicOrder = new LinkedHashMap();
    public LinkedHashMap orderitems = null;
    public LinkedHashMap dicRequest = new LinkedHashMap();
    public LinkedHashMap splitAccInfoItems = null;

    public QuickPaymentRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "KPayVerifyReq");
        this.orderitems = new LinkedHashMap();
        this.splitAccInfoItems = new LinkedHashMap();
        this.dicOrder.put("PayTypeID", "");
        this.dicOrder.put("orderTimeoutDate", "");
        this.dicOrder.put("OrderNo", "");
        this.dicOrder.put("CurrencyCode", "");
        this.dicOrder.put("OrderAmount", "");
        this.dicOrder.put("ExpiredDate", "");
        this.dicOrder.put("OrderDesc", "");
        this.dicOrder.put("OrderDate", "");
        this.dicOrder.put("OrderTime", "");
        this.dicOrder.put("ReceiverAddress", "");
        this.dicOrder.put("BuyIP", "");
        this.dicRequest.put("CardNo", "");
        this.dicRequest.put("MobileNo", "");
        this.dicRequest.put("CommodityType", "");
        this.dicRequest.put("Installment", "");
        this.dicRequest.put("ProjectID", "");
        this.dicRequest.put("Period", "");
        this.dicRequest.put("PaymentType", "");
        this.dicRequest.put("PaymentLinkType", "");
        this.dicRequest.put("ReceiveAccount", "");
        this.dicRequest.put("ReceiveAccName", "");
        this.dicRequest.put("MerchantRemarks", "");
        this.dicRequest.put("IsBreakAccount", "");
        this.dicRequest.put("SplitAccTemplate", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        String tError = this.isValid();
        if (tError.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01[" + tError + "]");
        }
    }

    public String isValid() throws TrxException {
        if (!DataVerifier.isValidAccount(this.dicRequest.get("CardNo").toString())) {
            return "\u652f\u4ed8\u8d26\u6237\u4e0d\u5408\u6cd5!";
        }
        if (this.dicRequest.get("CardNo").toString().length() < 6 || this.dicRequest.get("CardNo").toString().length() > 30) {
            return "\u652f\u4ed8\u8d26\u6237\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("MobileNo").toString())) {
            return "\u624b\u673a\u53f7\u672a\u8bbe\u7f6e!";
        }
        if (this.dicRequest.get("MobileNo").toString().length() != 4) {
            return "\u624b\u673a\u53f7\u957f\u5ea6\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValid(this.dicRequest.get("MobileNo").toString())) {
            return "\u624b\u673a\u53f7\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("CommodityType").toString())) {
            return "\u5546\u54c1\u79cd\u7c7b\u672a\u8bbe\u5b9a!";
        }
        if (this.dicRequest.get("CommodityType").toString().length() != 4) {
            return "\u5546\u54c1\u79cd\u7c7b\u4e0d\u5408\u6cd5";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("Installment").toString())) {
            return "\u5206\u671f\u6807\u8bc6\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicRequest.get("Installment").toString().equals("1") && !this.dicRequest.get("Installment").toString().equals("0")) {
            return "\u5206\u671f\u6807\u8bc6\u4e3a\u7a7a\u6216\u8f93\u5165\u975e\u6cd5!";
        }
        if (this.dicRequest.get("Installment").toString().equals("1")) {
            if (!DataVerifier.isValidString(this.dicRequest.get("ProjectID").toString(), 8)) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u4ee3\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a8\u4f4d!");
            }
            if (!DataVerifier.isValidString(this.dicRequest.get("Period").toString(), 2) || !DataVerifier.isValid(this.dicRequest.get("Period").toString())) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u671f\u671f\u6570\u975e\u6709\u6548\u6570\u5b57\u6216\u8005\u957f\u5ea6\u8d85\u8fc72!");
            }
        } else {
            this.dicRequest.remove("ProjectID");
            this.dicRequest.remove("Period");
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("PaymentType").toString())) {
            return "\u652f\u4ed8\u7c7b\u578b\u672a\u8bbe\u5b9a!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("PaymentLinkType").toString())) {
            return "\u652f\u4ed8\u6e20\u9053\u672a\u8bbe\u5b9a!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("PayTypeID").toString())) {
            return "\u4ea4\u6613\u7c7b\u578b\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicOrder.get("PayTypeID").toString().equals("ImmediatePay") && !this.dicOrder.get("PayTypeID").toString().equals("DividedPay")) {
            return "\u4ea4\u6613\u7c7b\u578b\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderNo").toString(), 60)) {
            return "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a\u6216\u8d85\u8fc7\u957f\u5ea6\u9650\u5236!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderAmount").toString())) {
            return "\u8ba2\u5355\u91d1\u989d\u672a\u8bbe\u5b9a!";
        }
        if (Double.parseDouble(this.dicOrder.get("OrderAmount").toString()) <= 0.0) {
            return "\u8ba2\u5355\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e\u96f6!";
        }
        if (!DataVerifier.isValidAmount(new BigDecimal(this.dicOrder.get("OrderAmount").toString()), 2)) {
            return "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5!";
        }
        if (this.dicOrder.get("OrderDesc").toString().getBytes().length > 100) {
            return "\u8ba2\u5355\u8bf4\u660e\u8d85\u957f!";
        }
        if (!DataVerifier.isValidDate(this.dicOrder.get("OrderDate").toString())) {
            return "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidTime(this.dicOrder.get("OrderTime").toString())) {
            return "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("CurrencyCode").toString())) {
            return "\u4ea4\u6613\u5e01\u79cd\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicOrder.get("CurrencyCode").toString().equals("156")) {
            return "\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("IsBreakAccount").toString())) {
            return "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5";
        }
        if (!this.dicRequest.get("IsBreakAccount").toString().equals("0") && !this.dicRequest.get("IsBreakAccount").toString().equals("1")) {
            return "\u5206\u8d26\u4fe1\u606f\u4e0d\u5408\u6cd5";
        }
        if (this.dicRequest.get("IsBreakAccount").toString().equals("0") && this.splitAccInfoItems.size() > 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5206\u8d26\u6807\u5fd7\u4e3a0\u65f6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5206\u8d26\u4fe1\u606f");
        }
        LinkedHashMap orderitem = new LinkedHashMap();
        Set entries = this.orderitems.entrySet();
        for (Map.Entry entrys : entries) {
            orderitem = (LinkedHashMap)entrys.getValue();
            Set entrie = orderitem.entrySet();
            for (Map.Entry entry : entrie) {
                if (!entry.getKey().toString().equals("ProductName") || entry.getValue().toString().length() != 0) continue;
                return "\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a!";
            }
        }
        return "";
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"Order\":";
        js = js + JSON.WriteDictionary(this.dicOrder);
        if (this.orderitems.size() > 0) {
            js = js + ",\"OrderItems\":";
            js = js + JSON.WriteDictionarys(this.orderitems);
        }
        if (this.splitAccInfoItems.size() > 0) {
            js = js + ",\"SplitAccInfoItems\":";
            js = js + JSON.WriteDictionarys(this.splitAccInfoItems);
        }
        js = js + "}";
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

