/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;

public class QuickPaymentSend
extends TrxRequest {
    public LinkedHashMap<String, String> dicOrder = new LinkedHashMap();
    public LinkedHashMap<String, String> dicRequest = new LinkedHashMap();

    public QuickPaymentSend() {
        super("EBUS");
        this.dicRequest.put("TrxType", "KPayReq");
        this.dicOrder.put("OrderNo", "");
        this.dicOrder.put("CurrencyCode", "");
        this.dicOrder.put("OrderAmount", "");
        this.dicOrder.put("Fee", "");
        this.dicOrder.put("OrderDate", "");
        this.dicOrder.put("OrderTime", "");
        this.dicRequest.put("AccName", "");
        this.dicRequest.put("CertificateType", "");
        this.dicRequest.put("CertificateID", "");
        this.dicRequest.put("ExpDate", "");
        this.dicRequest.put("CVV2", "");
        this.dicRequest.put("VerifyCode", "");
        this.dicRequest.put("PaymentType", "");
        this.dicRequest.put("PayLinkType", "");
        this.dicRequest.put("MerchantRemarks", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        String tError = this.isValid();
        if (tError.length() != 0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5408\u6cd5\uff01[" + tError + "]");
        }
    }

    public String isValid() {
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderNo").toString(), 60)) {
            return "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a\u6216\u8d85\u8fc7\u957f\u5ea6\u9650\u5236!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("OrderAmount").toString())) {
            return "\u8ba2\u5355\u91d1\u989d\u672a\u8bbe\u5b9a!";
        }
        if (Double.parseDouble(this.dicOrder.get("OrderAmount").toString()) <= 0.0) {
            return "\u8ba2\u5355\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e\u96f6!";
        }
        if (!DataVerifier.isValidAmount(new BigDecimal(this.dicOrder.get("OrderAmount").toString()), 2)) {
            return "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidDate(this.dicOrder.get("OrderDate").toString())) {
            return "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidTime(this.dicOrder.get("OrderTime").toString())) {
            return "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicOrder.get("CurrencyCode").toString())) {
            return "\u4ea4\u6613\u5e01\u79cd\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicOrder.get("CurrencyCode").toString().equals("156")) {
            return "\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("PaymentType").toString())) {
            return "\u652f\u4ed8\u7c7b\u578b\u672a\u8bbe\u5b9a!";
        }
        if (!DataVerifier.isValidString(this.dicRequest.get("PayLinkType").toString())) {
            return "\u652f\u4ed8\u6e20\u9053\u672a\u8bbe\u5b9a!";
        }
        if (!this.dicRequest.get("PayLinkType").toString().equals("1") && !this.dicRequest.get("PayLinkType").toString().equals("2")) {
            return "\u652f\u4ed8\u6e20\u9053\u4e0d\u5408\u6cd5!";
        }
        if (this.dicRequest.get("Fee") != null && !this.dicRequest.get("Fee").toString().equals("")) {
            if (Double.parseDouble(this.dicOrder.get("Fee").toString()) <= 0.0) {
                return "\u624b\u7eed\u8d39\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e\u96f6!";
            }
            if (!DataVerifier.isValidAmount(new BigDecimal(this.dicOrder.get("Fee").toString()), 2)) {
                return "\u624b\u7eed\u8d39\u91d1\u989d\u4e0d\u5408\u6cd5!";
            }
        }
        if (this.dicRequest.get("ExpDate") != null && !this.dicRequest.get("ExpDate").toString().equals("")) {
            if (!DataVerifier.isValid(this.dicRequest.get("ExpDate").toString())) {
                return "\u8d37\u8bb0\u5361\u6709\u6548\u671f\u4e0d\u5408\u6cd5!";
            }
            if (this.dicRequest.get("ExpDate").toString().length() != 4) {
                return "\u8d37\u8bb0\u5361\u6709\u6548\u671f\u4e0d\u5408\u6cd5!";
            }
        }
        if (this.dicRequest.get("CVV2") != null && !this.dicRequest.get("CVV2").toString().equals("")) {
            if (!DataVerifier.isValid(this.dicRequest.get("CVV2").toString())) {
                return "CVV2\u4e0d\u5408\u6cd5!";
            }
            if (this.dicRequest.get("CVV2").toString().length() != 3) {
                return "CVV2\u4e0d\u5408\u6cd5!";
            }
        }
        return "";
    }

    @Override
    protected String getRequestMessage() throws TrxException {
        String js = "\"Order\":";
        js = js + JSON.WriteDictionary(this.dicOrder);
        js = js + "}";
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        tMessage = tMessage + ",";
        tMessage = tMessage + js;
        return tMessage;
    }
}

