/*
 * Decompiled with CFR 0.152.
 */
package com.abc.pay.client.ebus;

import com.abc.pay.client.DataVerifier;
import com.abc.pay.client.JSON;
import com.abc.pay.client.TrxException;
import com.abc.pay.client.TrxRequest;
import java.math.BigDecimal;
import java.util.LinkedHashMap;

public class RefundRequest
extends TrxRequest {
    public LinkedHashMap<String, String> dicRequest = new LinkedHashMap();
    public LinkedHashMap dicSplitAccInfo = new LinkedHashMap();
    public LinkedHashMap dicTemplalteSplitAccInfo = new LinkedHashMap();

    public RefundRequest() {
        super("EBUS");
        this.dicRequest.put("TrxType", "Refund");
        this.dicRequest.put("OrderDate", "");
        this.dicRequest.put("OrderTime", "");
        this.dicRequest.put("MerRefundAccountNo", "");
        this.dicRequest.put("MerRefundAccountName", "");
        this.dicRequest.put("OrderNo", "");
        this.dicRequest.put("NewOrderNo", "");
        this.dicRequest.put("CurrencyCode", "");
        this.dicRequest.put("TrxAmount", "");
        this.dicRequest.put("RefundType", "");
        this.dicRequest.put("MerchantRemarks", "");
        this.dicRequest.put("MerRefundAccountFlag", "");
    }

    @Override
    protected void checkRequest() throws TrxException {
        if (this.dicRequest.get("OrderNo") == null || this.dicRequest.get("OrderNo").toString().length() > 60) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u539f\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicRequest.get("NewOrderNo") == null || this.dicRequest.get("NewOrderNo").toString().length() > 60) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u4ea4\u6613\u7f16\u53f7\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicRequest.get("OrderDate") == null || !DataVerifier.isValidDate(this.dicRequest.get("OrderDate").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicRequest.get("OrderTime") == null || !DataVerifier.isValidTime(this.dicRequest.get("OrderTime").toString())) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicRequest.get("CurrencyCode") == null || !this.dicRequest.get("CurrencyCode").toString().equals("156")) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5b8c\u6574", "\u8bbe\u5b9a\u4ea4\u6613\u5e01\u79cd\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.dicRequest.get("TrxAmount") == null) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u91d1\u989d\u672a\u8bbe\u5b9a\uff01");
        }
        String amountStr = this.dicRequest.get("TrxAmount").toString();
        BigDecimal amount = new BigDecimal(amountStr);
        if (!DataVerifier.isValidAmount(amount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u4ea4\u6613\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
    }

    @Override
    public String getRequestMessage() throws TrxException {
        String tMessage = JSON.WriteDictionary(this.dicRequest);
        String js = "";
        if (this.dicSplitAccInfo.size() > 0) {
            js = js + "\"SplitMerInfo\":";
            js = js + JSON.WriteDictionarys(this.dicSplitAccInfo);
            tMessage = tMessage + ",";
            tMessage = tMessage + js;
        }
        if (this.dicTemplalteSplitAccInfo.size() > 0) {
            String templateJs = "";
            templateJs = templateJs + "\"TemplateSplitAccInfo\":";
            templateJs = templateJs + JSON.WriteDictionarys(this.dicTemplalteSplitAccInfo);
            tMessage = tMessage + ",";
            tMessage = tMessage + templateJs;
        }
        return tMessage;
    }

    public void setConnectionFlag(boolean flag) {
        this.connectionFlag = flag;
    }
}

