package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSONObject;

/**
 * 支付宝预授权支付响应类
 * 对应支付宝 alipay.fund.auth.order.voucher.create 接口响应
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthPayResponse extends BaseChargeResponse {
    private static final long serialVersionUID = 7218410823559348341L;

    /**
     * 支付宝资金授权订单号
     */
    private String authNo;

    /**
     * 支付宝资金操作流水号
     */
    private String operationId;

    /**
     * 商户本次资金操作的请求流水号
     */
    private String outRequestNo;

    /**
     * 本次操作金额，单位为：元（人民币），精确到小数点后两位
     */
    private String amount;

    /**
     * 资金操作流水的状态
     * SUCCESS：成功
     * FAIL：失败
     */
    private String status;

    /**
     * 支付宝资金操作流水创建时间
     */
    private String gmtCreate;

    /**
     * 支付宝侧资金操作流水的业务时间
     */
    private String gmtTrans;

    /**
     * 授权资金预授权冻结时间
     */
    private String preAuthType;

    /**
     * 授权资金明细的状态
     * INIT：初始
     * SUCCESS：成功
     * CLOSED：关闭
     */
    private String creditAmount;

    /**
     * 授权资金明细的剩余冻结金额
     */
    private String restAmount;

    /**
     * 总冻结金额
     */
    private String totalFreezeAmount;

    /**
     * 实际收款金额，单位为：元（人民币），精确到小数点后两位
     */
    private String receiptAmount;

    /**
     * 买家支付宝账号
     */
    private String buyerLogonId;

    // Getter and Setter methods
    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getGmtTrans() {
        return gmtTrans;
    }

    public void setGmtTrans(String gmtTrans) {
        this.gmtTrans = gmtTrans;
    }

    public String getPreAuthType() {
        return preAuthType;
    }

    public void setPreAuthType(String preAuthType) {
        this.preAuthType = preAuthType;
    }

    public String getCreditAmount() {
        return creditAmount;
    }

    public void setCreditAmount(String creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String getRestAmount() {
        return restAmount;
    }

    public void setRestAmount(String restAmount) {
        this.restAmount = restAmount;
    }

    public String getTotalFreezeAmount() {
        return totalFreezeAmount;
    }

    public void setTotalFreezeAmount(String totalFreezeAmount) {
        this.totalFreezeAmount = totalFreezeAmount;
    }

    public String getReceiptAmount() {
        return receiptAmount;
    }

    public void setReceiptAmount(String receiptAmount) {
        this.receiptAmount = receiptAmount;
    }

    public String getBuyerLogonId() {
        return buyerLogonId;
    }

    public void setBuyerLogonId(String buyerLogonId) {
        this.buyerLogonId = buyerLogonId;
    }

    @Override
    public String getExtra() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("authNo", authNo);
        jsonObject.put("operationId", operationId);
        jsonObject.put("outRequestNo", outRequestNo);
        jsonObject.put("amount", amount);
        jsonObject.put("status", status);
        jsonObject.put("gmtCreate", gmtCreate);
        jsonObject.put("gmtTrans", gmtTrans);
        jsonObject.put("preAuthType", preAuthType);
        jsonObject.put("creditAmount", creditAmount);
        jsonObject.put("restAmount", restAmount);
        jsonObject.put("totalFreezeAmount", totalFreezeAmount);
        jsonObject.put("receiptAmount", receiptAmount);
        jsonObject.put("buyerLogonId", buyerLogonId);
        return jsonObject.toJSONString();
    }
} 