package cn.com.duiba.paycenter.dto.payment.charge.elife;

import java.io.Serializable;

/**
 * 江苏工行-e生活-支付请求request
 *
 * @author songp
 * @date 2024/5/10 2:18 下午
 */
public class IcbcELifeCreatePayRequest implements Serializable {

    private static final long serialVersionUID = 9164182528682621686L;

    /**
     * 接口名称,必输，取值：“ICBC_WAPB_B2C”
     */
    private String interfaceName;

    /**
     * 接口版本号,必输，取值：“1.0.0.6”
     */
    private String interfaceVersion;

    /**
     * 交易数据,
     * 必输，签名；
     * 整合所有交易数据形成的xml明文串，并做BASE64编码；
     * 具体格式定义见下文；
     * 注意：需有xml头属性；整个字段使用BASE64编码；
     * xml明文中没有回车换行和多余空格；
     */
    private String tranData;

    /**
     * 订单签名数据
     * 必输，商户使用工行提供的签名API和商户证书将tranData的xml明文串进行签名，得到二进制签名数据，然后进行BASE64编码后得到可视的merSignMsg；
     * 注意：签名时是针对tranData的xml明文，不是将tranData进行BASE64编码后的串；
     */
    private String merSignMsg;

    /**
     * 商城证书公钥，
     * 必输，商户用二进制方式读取证书公钥文件后，进行BASE64编码后产生的字符串；
     */
    private String merCert;

    /**
     * 启动类型
     * 必输，
     * 取值：
     * 1：工行iPhone客户端版
     * 2：工行Android客户端版
     * 21：工行移动生活版（iPhone）
     * 22：工行移动生活版（Android）
     * 0：HTML版（只支持iPhone、Android的webkit核心浏览器）
     */
    private String clientType;

    /**
     * 订单签名算法
     * 选输，不输则默认为0。
     * 0：SHA1withRSA；
     * 1：SHA256withRSA
     */
    private String merSignAlg;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceVersion() {
        return interfaceVersion;
    }

    public void setInterfaceVersion(String interfaceVersion) {
        this.interfaceVersion = interfaceVersion;
    }

    public String getTranData() {
        return tranData;
    }

    public void setTranData(String tranData) {
        this.tranData = tranData;
    }

    public String getMerSignMsg() {
        return merSignMsg;
    }

    public void setMerSignMsg(String merSignMsg) {
        this.merSignMsg = merSignMsg;
    }

    public String getMerCert() {
        return merCert;
    }

    public void setMerCert(String merCert) {
        this.merCert = merCert;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getMerSignAlg() {
        return merSignAlg;
    }

    public void setMerSignAlg(String merSignAlg) {
        this.merSignAlg = merSignAlg;
    }
}
