package cn.com.duiba.paycenter.dto.payment.charge.elife;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 江苏工行-e生活-支付状态查询request
 *
 * @author songp
 * @date 2024/5/11 5:21 下午
 */
public class IcbcELifePayQueryRequest implements Serializable {

    private static final long serialVersionUID = 8535820434069399312L;


    /**
     * 商户代码
     * 唯一确定一个商户的代码，由商户在工行开户时，由工行告知商户。
     */
    private String merID;

    /**
     * 下单支付订单号
     */
    @NotNull(message = "下单支付订单号不能为空")
    private String payOrderNo;

    public String getMerID() {
        return merID;
    }

    public void setMerID(String merID) {
        this.merID = merID;
    }

    public String getPayOrderNo() {
        return payOrderNo;
    }

    public void setPayOrderNo(String payOrderNo) {
        this.payOrderNo = payOrderNo;
    }
}
