package cn.com.duiba.paycenter.dto.payment.charge.elife.dto;

import java.io.Serializable;

public class IcbcELifeMessage implements Serializable {

    private static final long serialVersionUID = 8535820434069399311L;

    /**
     * 商品编号，选输
     */
    private String goodsID;

    /**
     * 商品名称，选输
     */
    private String goodsName;

    /**
     * 商品数量，选输
     */
    private String goodsNum;

    /**
     * 已含运费金额，选输
     */
    private String carriageAmt;

    /**
     * 商城提示，选输
     */
    private String merHint;

    /**
     * 备注字段1
     * 选输
     * 如果希望对订单的有效日期进行限定，此项必须输入类似”20110802152230”的时间串代表8月2日15:22:30之前支付订单有效。
     * 若不需要限定，此项送空，送其他值不合法。
     */
    private String remark1;

    /**
     * 备注字段2，选输
     */
    private String remark2;

    /**
     * 通知商户URL,必输
     * 必须合法的URL，交易结束，银行使用HTTP协议POST方式向此地址发送通知信息；目前只支持80端口。
     */
    private String merURL;

    /**
     * 返回商户变量,选输
     * 商户自定义，当返回银行结果时，作为一个隐藏域变量，商户可以用此变量维护session等等。
     * 由客户端浏览器支付完成后提交通知结果时是明文传输，建议商户对此变量使用额外安全防范措施，如签名、base64
     */
    private String merVAR;

    /**
     * 通知类型
     * 必输
     * 在交易转账处理完成后把交易结果通知商户的处理模式。
     * 取值“HS”：在交易完成后实时将通知信息以HTTP协议POST方式，主动发送给商户，
     * 发送地址为商户端随订单数据提交的接收工行支付结果的URL即表单中的merURL字段；
     * 取值“AG”：在交易完成后不通知商户。商户需使用浏览器登录工行的B2C商户服务网站，
     * 或者使用工行提供的客户端程序API主动获取通知信息。
     * 取值“TS”：在交易完成后实时将通知信息以HTTP协议POST方式，主动发送给商户，
     * 发送地址为商户端随订单数据提交的接收工行支付结果的URL即表单中的merURL字段，
     * 商户响应银行通知时返回取货链接给工行，如工行未收到商户响应则重复发送通知消息，发送次数由工行参数配置。
     */
    private String notifyType;

    /**
     * 结果发送类型
     * 选输
     * 取值“0”：无论支付成功或者失败，银行都向商户发送交易通知信息；
     * 取值“1”，银行只向商户发送交易成功的通知信息。（推荐）
     * 只有通知方式为HS时此值有效，如果使用AG方式，可不上送此项，但签名数据中必须包含此项，取值可为空。
     */
    private String resultType;

    /**
     * 备用字段1
     * 选输 （此字段仅供电商平台订单使用，电商平台订单必输，其他订单不输入此字段）输入格式要求为：“订单类型|电商渠道优惠率|积分兑换事件编号，
     * （1）订单类型：如果是电商平台订单，送Eshop
     * （2）电商渠道优惠率：送入百分比如果送入90，认为是9折优惠
     * （3）积分兑换事件编号
     * 例如：Eshop|100|110110001101000101000，其它非电商订单不使用此字段
     */
    private String backup1;

    /**
     * 备用字段2
     * 不输，预留字段
     */
    private String backup2;

    /**
     * 备用字段3
     * 不输，预留字段
     */
    private String backup3;

    /**
     * 备用字段4
     * 不输，预留字段
     */
    private String backup4;

    /**
     * 支付通知是否支持优惠信息
     * 0-不支持
     * 1-支持
     * 选输，
     * 如商户需要在工行返回的通知消息结果中包含优惠信息的内容，则该字段送1-支持
     */
    private String isSupportDISCOUFlag;

    /**
     * 成功页自动跳转商户倒计时参数
     * 选输,单位（秒）
     * 当商户返回的商城取货地址为正常可达时，如该参数非空，则倒计时结束后自动跳转回商城取货地址对应链接，如不上送则默认不自动跳转。
     */
    private String autoReferSec;

    public String getGoodsID() {
        return goodsID;
    }

    public void setGoodsID(String goodsID) {
        this.goodsID = goodsID;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsNum() {
        return goodsNum;
    }

    public void setGoodsNum(String goodsNum) {
        this.goodsNum = goodsNum;
    }

    public String getCarriageAmt() {
        return carriageAmt;
    }

    public void setCarriageAmt(String carriageAmt) {
        this.carriageAmt = carriageAmt;
    }

    public String getMerHint() {
        return merHint;
    }

    public void setMerHint(String merHint) {
        this.merHint = merHint;
    }

    public String getRemark1() {
        return remark1;
    }

    public void setRemark1(String remark1) {
        this.remark1 = remark1;
    }

    public String getRemark2() {
        return remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getMerURL() {
        return merURL;
    }

    public void setMerURL(String merURL) {
        this.merURL = merURL;
    }

    public String getMerVAR() {
        return merVAR;
    }

    public void setMerVAR(String merVAR) {
        this.merVAR = merVAR;
    }

    public String getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public String getResultType() {
        return resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public String getBackup1() {
        return backup1;
    }

    public void setBackup1(String backup1) {
        this.backup1 = backup1;
    }

    public String getBackup2() {
        return backup2;
    }

    public void setBackup2(String backup2) {
        this.backup2 = backup2;
    }

    public String getBackup3() {
        return backup3;
    }

    public void setBackup3(String backup3) {
        this.backup3 = backup3;
    }

    public String getBackup4() {
        return backup4;
    }

    public void setBackup4(String backup4) {
        this.backup4 = backup4;
    }

    public String getIsSupportDISCOUFlag() {
        return isSupportDISCOUFlag;
    }

    public void setIsSupportDISCOUFlag(String isSupportDISCOUFlag) {
        this.isSupportDISCOUFlag = isSupportDISCOUFlag;
    }

    public String getAutoReferSec() {
        return autoReferSec;
    }

    public void setAutoReferSec(String autoReferSec) {
        this.autoReferSec = autoReferSec;
    }
}
