package cn.com.duiba.paycenter.dto.payment.charge.icbcelife;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;

/**
 * @author haojiahong
 * @date 2022-06-10
 */
public class IcbcElife4WxChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 7499591634521646947L;


    /**
     * 交易日期，格式:yyyyMMdd
     * 必填
     */
    @NotBlank(message = "交易日期必填")
    private String tradeDate;

    /**
     * 交易时间，格式: HHmmss
     * 必填
     */
    @NotBlank(message = "交易时间必填")
    private String tradeTime;

    /**
     * 商户订单有效期，单位：秒，必须小于24小时
     * 必填
     */
    @NotBlank(message = "商户订单有效期必填")
    private String payExpire;

    /**
     * 商户接收支付成功通知消息URL,当notify_flag为1时必输，最大长度100个字符
     */
    private String notifyUrl;

    /**
     * 商户是否开启通知接口 0-否；1-是；非1按0处理
     * 必填
     */
    @NotBlank(message = "商户是否开启通知接口必填")
    private String notifyFlag;


    /**
     * 商户订单生成的机器IP
     * 必填
     */
    @NotBlank(message = "商户订单生成的机器IP必填")
    private String tporderCreateIp;

    /**
     * 扫码后是否需要跳转分行，0：否，1：是；非1按0处理
     */
    private String spFlag;

    /**
     * 商户附加数据，最多21个汉字字符（为便于区分统计，小程序支付时，请上送“OFSTMINI:活动号”，支付完成后，按照活动号进行跳转）
     */
    private String attach;

    public String getTradeDate() {
        return tradeDate;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }

    public String getTradeTime() {
        return tradeTime;
    }

    public void setTradeTime(String tradeTime) {
        this.tradeTime = tradeTime;
    }

    public String getPayExpire() {
        return payExpire;
    }

    public void setPayExpire(String payExpire) {
        this.payExpire = payExpire;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getNotifyFlag() {
        return notifyFlag;
    }

    public void setNotifyFlag(String notifyFlag) {
        this.notifyFlag = notifyFlag;
    }

    public String getTporderCreateIp() {
        return tporderCreateIp;
    }

    public void setTporderCreateIp(String tporderCreateIp) {
        this.tporderCreateIp = tporderCreateIp;
    }

    public String getSpFlag() {
        return spFlag;
    }

    public void setSpFlag(String spFlag) {
        this.spFlag = spFlag;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }
}
