package cn.com.duiba.paycenter.dto.payment.charge.weibo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 微博支付回调、退款回调同一个接口，这里参数也放到一起
 */
public class WeiboChargeNotifyData implements Serializable {
    private static final long serialVersionUID = 7634992480962538712L;
    /**
     * 通知类型：退款
     */
    public static final String NOTIFY_TYPE_REFUND = "PAY_REFUND_NOTIFY";
    /**
     * 支付状态-待支付
     */
    public static final String PAY_STATUS_PENDING = "PAY_STATUS_PENDING";
    /**
     * 支付状态-成功
     */
    public static final String PAY_STATUS_SUCCESS = "PAY_STATUS_SUCCESS";
    /**
     * 支付状态-关闭
     */
    public static final String PAY_STATUS_CLOSED = "PAY_STATUS_CLOSED";

    /**
     * 退款状态-退款中
     */
    public static final String REFUND_STATUS_PENDING = "PAY_REFUND_STATUS_PENDING";

    /**
     * 退款状态：退款成功
     */
    public static final String REFUND_STATUS_SUCCESS = "PAY_REFUND_STATUS_SUCCESS";

    /**
     * 退款状态-退款失败
     */
    public static final String REFUND_STATUS_FAIL = "PAY_REFUND_STATUS_FAIL";

    /**
     * 通知类型，
     * 退款通知才有此参数
     * 退款通知：PAY_REFUND_NOTIFY
     */
    @JsonProperty(value = "notify_type")
    private String notifyType;

    /**
     * 微博支付单id
     */
    @JsonProperty(value = "pay_id")
    private Long payId;

    /**
     * 外部支付单ID
     */
    @JsonProperty(value = "out_pay_id")
    private String outPayId;

    /**
     * 外部退款单 ID
     * 退款通知才有此参数
     */
    @JsonProperty(value = "out_refund_id")
    private String outRefundId;

    /**
     * 服务商微博 UID
     */
    @JsonProperty(value = "seller_id")
    private Long sellerId;

    /**
     * 买家微博 UID
     */
    @JsonProperty(value = "buyer_id")
    private Long buyerId;

    /**
     * 支付退款id
     * 退款通知才有此参数
     */
    @JsonProperty(value = "refund_id")
    private Long refundId;

    /**
     * 支付退款金额
     * 退款通知才有此参数
     */
    @JsonProperty(value = "refund_amount")
    private Integer refundAmount;

    /**
     * 退款时间，格式为：Y-m-d H:i:s
     * 退款通知才有此参数
     */
    @JsonProperty(value = "refund_time")
    private String refundTime;

    /**
     * 退分账标记
     * 退款通知才有此参数
     * 0 代表仅退款，1 代表有退分账 （目前业务没有分账）
     */
    @JsonProperty(value = "refund_transfer")
    private Integer refundTransfer;

    /** 支付方式（3：微信，4：支付宝，5：花呗分期） */
    @JsonProperty(value = "pay_method")
    private Integer payMethod;

    /** 商品名称 */
    @JsonProperty(value = "subject")
    private String subject;

    /** 商品总价（以分为单位） */
    @JsonProperty(value = "total_amount")
    private Integer totalAmount;

    /** 商品描述 */
    @JsonProperty(value = "body")
    private String body;

    /** appkey */
    @JsonProperty(value = "appkey")
    private String appkey;

    /** 附加信息 */
    @JsonProperty(value = "extra")
    private String extra;

    /** 支付单状态（PAY_STATUS_PENDING: 待支付，PAY_STATUS_SUCCESS: 已支付，PAY_STATUS_CLOSED: 已关闭） */
    @JsonProperty(value = "status")
    private String status;

    /** 支付时间，格式为：Y-m-d H:i:s */
    @JsonProperty(value = "pay_time")
    private String payTime;

    /** 签名 */
    @JsonProperty(value = "sign")
    private String sign;
    /**
     * 签名类型
     */
    @JsonProperty(value = "sign_type")
    private String signType;

    public String getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public Long getPayId() {
        return payId;
    }

    public void setPayId(Long payId) {
        this.payId = payId;
    }

    public String getOutPayId() {
        return outPayId;
    }

    public void setOutPayId(String outPayId) {
        this.outPayId = outPayId;
    }

    public String getOutRefundId() {
        return outRefundId;
    }

    public void setOutRefundId(String outRefundId) {
        this.outRefundId = outRefundId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public Long getRefundId() {
        return refundId;
    }

    public void setRefundId(Long refundId) {
        this.refundId = refundId;
    }

    public Integer getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(Integer refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(String refundTime) {
        this.refundTime = refundTime;
    }

    public Integer getRefundTransfer() {
        return refundTransfer;
    }

    public void setRefundTransfer(Integer refundTransfer) {
        this.refundTransfer = refundTransfer;
    }

    public Integer getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(Integer payMethod) {
        this.payMethod = payMethod;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Integer getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPayTime() {
        return payTime;
    }

    public void setPayTime(String payTime) {
        this.payTime = payTime;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }
}
