package cn.com.duiba.paycenter.dto.payment.charge.weibo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
public class WeiboSettleRequest implements Serializable {
    private static final long serialVersionUID = 1945046157642480388L;
    /**
     * 签名类型，当前使用的是 RSA 签名。
     * 必填字段。
     */
    @JSONField(name = "sign_type")
    private String signType;

    /**
     * 签名内容，用于验证请求的合法性。
     * 必填字段。
     */
    @JSONField(name = "sign")
    private String sign;

    /**
     * 服务商微博 UID，用于标识服务商。
     * 必填字段。
     */
    @JSONField(name = "seller_id")
    private Long sellerId;

    /**
     * 外部结算单号，业务方提供不重复的结算单号，用于幂等性判断。
     * 支持支付宝结算冻结模式，解冻时请使用请求冻结时填写的 out_settle_id。
     * 必填字段。
     */
    @JSONField(name = "out_settle_id")
    private String outSettleId;

    /**
     * 微博支付单号，用于标识微博支付。
     * 必填字段。
     */
    @JSONField(name = "pay_id")
    private Long payId;

    /**
     * 备注，用于描述结算的附加信息。
     * 非必填字段，微信支付必传。
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * 冻结状态，用于指定结算资金是否被冻结。
     * 仅支持支付宝订单结算资金冻结模式使用，若不传，默认为非冻结模式。
     * 1 - 发起结算资金冻结
     * 2 - 发起解冻
     * 选填字段。
     */
    @JSONField(name = "freeze")
    private Integer freeze;

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getOutSettleId() {
        return outSettleId;
    }

    public void setOutSettleId(String outSettleId) {
        this.outSettleId = outSettleId;
    }

    public Long getPayId() {
        return payId;
    }

    public void setPayId(Long payId) {
        this.payId = payId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getFreeze() {
        return freeze;
    }

    public void setFreeze(Integer freeze) {
        this.freeze = freeze;
    }
}
