package cn.com.duiba.paycenter.dto.payment.refund.alipay;

import cn.com.duiba.paycenter.dto.payment.refund.RefundResponse;

/**
 * 支付宝预授权解冻响应类
 * 对应支付宝 alipay.fund.auth.order.unfreeze 接口响应
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthUnfreezeResponse extends RefundResponse {
    private static final long serialVersionUID = 1L;

    /**
     * 支付宝资金授权订单号
     */
    private String authNo;

    /**
     * 支付宝资金操作流水号
     */
    private String operationId;

    /**
     * 商户本次资金操作的请求流水号
     */
    private String outRequestNo;

    /**
     * 本次操作解冻的金额，单位为：元（人民币），精确到小数点后两位
     */
    private String amount;

    /**
     * 资金操作流水的状态
     * 目前支持：SUCCESS：成功
     */
    private String status;

    /**
     * 商户的授权资金订单号
     */
    private String outOrderNo;

    /**
     * 授权资金解冻成功时间，格式：YYYY-MM-DD HH:MM:SS
     */
    private String gmtTrans;

    /**
     * 本次解冻操作中信用解冻金额，单位为：元（人民币），精确到小数点后两位
     */
    private String creditAmount;

    /**
     * 本次解冻操作中自有资金解冻金额，单位为：元（人民币），精确到小数点后两位
     */
    private String fundAmount;

    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOutOrderNo() {
        return outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public String getGmtTrans() {
        return gmtTrans;
    }

    public void setGmtTrans(String gmtTrans) {
        this.gmtTrans = gmtTrans;
    }

    public String getCreditAmount() {
        return creditAmount;
    }

    public void setCreditAmount(String creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String getFundAmount() {
        return fundAmount;
    }

    public void setFundAmount(String fundAmount) {
        this.fundAmount = fundAmount;
    }
} 