/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class LshmPayUtils {
    public static final String CHARSET = "UTF-8";
    public static final String AES_ALGORITHM = "AES";
    private static final String ALGORITHM_PKCS5 = "AES/ECB/PKCS5Padding";
    public static final String RSA_ALGORITHM = "RSA";
    private static final String KEY_RSA_SIGNATURE = "SHA1withRSA";

    public static String aesEncrypt(String thisKey, String data) {
        try {
            SecretKeySpec key = new SecretKeySpec(thisKey.getBytes(), AES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM_PKCS5);
            cipher.init(1, key);
            byte[] plainBytes = data.getBytes(CHARSET);
            byte[] result = cipher.doFinal(plainBytes);
            return Base64.encodeBase64String((byte[])result);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("aes\u52a0\u5bc6\u5931\u8d25");
        }
    }

    public static String aesDecrypt(String thisKey, String encryptedData) {
        try {
            SecretKeySpec key = new SecretKeySpec(thisKey.getBytes(), AES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM_PKCS5);
            cipher.init(2, key);
            byte[] encryptedBytes = Base64.decodeBase64((String)encryptedData);
            byte[] result = cipher.doFinal(encryptedBytes);
            return new String(result, CHARSET);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("aes\u89e3\u5bc6\u5931\u8d25");
        }
    }

    public static String rsaSign(byte[] data, String privateKey) {
        String str = "";
        try {
            byte[] bytes = Base64.decodeBase64((String)privateKey);
            PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(RSA_ALGORITHM);
            PrivateKey key = factory.generatePrivate(pkcs);
            Signature signature = Signature.getInstance(KEY_RSA_SIGNATURE);
            signature.initSign(key);
            signature.update(data);
            str = Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException("rsa\u7b7e\u540d\u5931\u8d25");
        }
        return str;
    }

    public static String privateEncrypt(String data, String privateKeyStr) {
        try {
            RSAPrivateKey privateKey = LshmPayUtils.getPrivateKey(privateKeyStr);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64String((byte[])LshmPayUtils.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }
}

