package cn.com.duiba.xxl.job.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.xxl.job.api.dto.XxlJobInfoDto;
import cn.com.duiba.xxl.job.common.dto.HandleCallbackParam;
import cn.com.duiba.xxl.job.common.dto.RegistryParam;
import cn.com.duiba.xxl.job.common.dto.ReturnT;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @Author: xutao
 * @Date: 2022/3/8 5:47 下午
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteJobService {
//    XxlJobInfoDto queryJob(String jobHandler) throws BizException;

    Pair<String, Boolean> addUpdateJob(XxlJobInfoDto jobInfo) throws BizException;

    Boolean startJob(String jobId) throws BizException;

    List<Long> removeJobList(String projectId);

    Boolean removeJob(Long jobId);

    /**
     * callback
     *
     * @param callbackParamList
     * @return
     */
    public ReturnT<String> callback(List<HandleCallbackParam> callbackParamList);


    // ---------------------- registry ----------------------

    /**
     * registry
     *
     * @param registryParam
     * @return
     */
    public ReturnT<String> registry(RegistryParam registryParam);

    /**
     * registry remove
     *
     * @param registryParam
     * @return
     */
    public ReturnT<String> registryRemove(RegistryParam registryParam);
}
