package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.pay.WxMpPayReq;
import cn.com.duiba.projectx.sdk.pay.WxMpPayResp;
import cn.com.duiba.projectx.sdk.pay.WxPayLiteReq;
import cn.com.duiba.projectx.sdk.pay.WxPayLiteResp;
import cn.com.duiba.projectx.sdk.pay.WxPayNotifyResp;
import cn.com.duiba.projectx.sdk.pay.WxPayStatus;
import cn.com.duiba.projectx.sdk.pay.WxRefundNotifyResp;
import cn.com.duiba.projectx.sdk.pay.WxSendCouponResp;
import cn.com.duiba.projectx.sdk.pay.WxTransferPaySendReq;
import cn.com.duiba.projectx.sdk.pay.WxTransferPaySendResp;
import cn.com.duiba.projectx.sdk.pay.WxWapPayReq;
import cn.com.duiba.projectx.sdk.pay.WxWapPayResp;

/**
 * @author liugq
 * @date 2020/03/22
 */
public interface WxPayApi {

    /**
     * 发起微信h5支付
     * @param request
     * @return
     */
    WxWapPayResp createWxWapPay(WxWapPayReq request) throws BizRuntimeException;

    /**
     * 支付订单状态查询
     * @param payRecordId
     * @return
     */
     WxPayStatus queryPayStatus(Long payRecordId) throws BizRuntimeException;

    /**
     * 发起微信公众号支付
     * @param request
     * @return
     */
    WxMpPayResp createWxMpPay(WxMpPayReq request) throws BizRuntimeException;

    /**
     * 发起微信小程序支付
     * @param request
     * @return
     */
    WxPayLiteResp createWxPayLitePay(WxPayLiteReq request) throws  BizRuntimeException;

    /**
     * 支付结果通知
     * @param xmlDataStr
     *1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     * InputStream inputStream = request.getInputStream()) {
     * String notifyString = IOUtils.toString(inputStream);
     *
     * 2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     * 可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxPayNotifyResp payOrderNotify(String xmlDataStr)  throws BizRuntimeException;

    /**
     * 发起退款：成功后返回退款订单号，否则抛出异常
     * @param payOrderId
     * @param callbackUrl : 退款发起后接收微信回调的url
     * @return 退款订单号
     *
     */
    String createWxRefund(Long payOrderId, String callbackUrl) throws BizRuntimeException;

    /**
     * 退款结果通知
     * @param xmlDataStr
     *1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     * InputStream inputStream = request.getInputStream()) {
     * String notifyString = IOUtils.toString(inputStream);
     *
     * 2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     * 可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxRefundNotifyResp refundOrderNotify(String xmlDataStr) throws BizRuntimeException;

    /**
     * 根据银行全称，获取微信支付银行返回的银行编码
     * @param bankName
     * @param type ： 1-借记卡 2-信用卡
     * @return
     */
    String getWxPayBank(String bankName, int type);

    /**
     * 微信发放优惠券（此接口当前只支持兑吧商户号，商户id:1227739602）
     *
     * @param openId 发放openId
     * @param stockId 优惠券批次号
     * @param stockCreatorMchid 制券者商户号（发放的是自己商户的优惠券则不需要填写，若发放开发者商户号创建的优惠券，则填写开发者商户号）
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(String openId, String stockId, String stockCreatorMchid) throws BizRuntimeException;

    WxTransferPaySendResp syncWxTransfer(WxTransferPaySendReq req) throws BizRuntimeException;



}
