package cn.com.duiba.quanyi.center.api.param.pay;

import lombok.Data;

import java.io.Serializable;

/**
 * 活动支付创建订单参数
 *
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class PayCreateOrderParam implements Serializable {

    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 订单业务主键
     */
    private Long payBizId;

    /**
     * 订单业务类型, 1-白名单活动，2-商品包
     *
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     */
    private Integer payBizType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 用户openId
     */
    private String openId;

    /**
     * 用户ip
     */
    private String userIp;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 支付商品名称
     */
    private String goodsName;
}
