package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponActivityDto;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteWxCouponActivityService {
    /**
     * 批量新增
     *
     * @param list 微信立减金活动关联
     * @return 执行结果
     */
    int batchInsert(List<WxCouponActivityDto> list);

    /**
     * 批量逻辑删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    @Deprecated
    Integer countByActivityPrizeId(Long activityPrizeId);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    @Deprecated
    List<WxCouponActivityDto> selectByActivityPrizeId(Long activityPrizeId);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    Integer countByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    List<WxCouponActivityDto> selectByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据立减金ID批量查询
     *
     * @param wxCouponIds 立减金ID集合
     * @return 微信立减金活动关联列表
     */
    List<WxCouponActivityDto> selectByWxCouponIds(Set<Long> wxCouponIds);
}
