package cn.com.duiba.quanyi.center.api.dto.pkg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包订单记录
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class GoodsPkgOrderRecordDto implements Serializable {

    private static final long serialVersionUID = 3603056637594319116L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 商品包推广渠道ID
     */
    private Long channelId;

    /**
     * 商品包主键
     */
    private Long goodsPkgId;

    /**
     * 商品包sku主键
     */
    private Long pkgSkuId;

    /**
     * 规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.goods.common.enums.goods.SpuType
     */
    private Integer spuType;

    /**
     * 绑定的券码
     */
    private String couponCode;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 账号信息
     */
    private String accountInfo;

    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 调用商品库的订单号
     */
    private String goodsOrderNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}