package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserDto;

import java.util.List;

/**
 * 用户
 *
 * @author lizhi
 * @date 2023/5/16 3:34 PM
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 新增或保存
     *
     * @param dto 用户信息
     * @return 主键
     */
    Long saveOrUpdate(UserDto dto);

    /**
     * 根据主键查询，redis缓存10分钟，变更时删除redis缓存
     *
     * @param id 主键
     * @return 用户
     */
    UserDto selectByIdCache(Long id);

    /**
     * 批量查询用户信息
     *
     * @param ids 主键集合
     * @return 用户信息集合
     */
    List<UserDto> selectByIds(List<Long> ids);

    /**
     * 根据类型和用户唯一id查询
     *
     * @param userType 用户类型
     * @param unionId  用户唯一id
     * @return 用户
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     */
    UserDto selectByUnionIdAndType(Integer userType, String unionId);
}
