package cn.com.duiba.quanyi.center.api.dto.demand;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需求商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class DemandGoodsDto implements Serializable {

    private static final long serialVersionUID = 5300114912265510532L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 合同商品id
     */
    private Long contractGoodsId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 商品规格Id
     */
    private Long skuId;

    /**
     * 面额，单位分
     */
    private Long amount;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}