package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.ActivityTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityDto implements Serializable {

    private static final long serialVersionUID = -2099354813835529791L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 背景图片
     */
    private String backgroundImg;

    /**
     * 小程序分享图
     */
    private String mpShareImg;

    /**
     * 按钮颜色
     */
    private String buttonColor;

    /**
     * 海报
     */
    private String sharePoster;

    /**
     * 客户经理端列表展示图
     */
    private String staffListImg;

    /**
     * 是否需要支付，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needPay;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 是否限制银行卡，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needLimitBank;

    /**
     * 限制的银行卡编码，以英文逗号分隔
     */
    private String limitBanks;

    /**
     * 是否退款，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needRefund;

    /**
     * 活动规则
     */
    private String activityRules;

    /**
     * 是否启用, 0-停用, 1-启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer activityStatus;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 活动类型
     *
     * @see ActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 客户经理海报
     */
    private String sharePosterStaff;

    /**
     * 支付类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.PayChannelEnum
     */
    private Integer payChannel;
}