package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.CcbZjPayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 活动支付创建订单参数
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class ActivityPayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 支付渠道
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String channelType = PayChannelTypeEnum.WX_LITE.getChannelType();

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;

    /**
     * 浙江建行支付参数
     */
    private CcbZjPayCreateOrderParam ccb;

    /**
     * 用户openId
     */
    @Deprecated
    private String openId;

    /**
     * 用户ip
     */
    @Deprecated
    private String userIp;
}
