package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 支付宝立减金后台类型
 */
@Getter
@AllArgsConstructor
public enum AlipayCountCoinsActivityTypeEnum {
    DEFAULT_TYPE(1, "默认类型", true)
    ;

    /**
     * 批次类型
     */
    private final Integer type;

    /**
     * 批次类型名称
     */
    private final String typeName;

    /**
     * 是否支持API发放
     */
    private final boolean supportApi;
    
    private static final Map<Integer, AlipayCountCoinsActivityTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(AlipayCountCoinsActivityTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static AlipayCountCoinsActivityTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static String getNameByType(Integer type) {
        AlipayCountCoinsActivityTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return "未知";
        }
        return typeEnum.getTypeName();
    }

    /**
     * 是否支持api发放
     *
     * @param type 枚举值
     * @return true-是，false-否
     */
    public static boolean isSupportApi(Integer type) {
        AlipayCountCoinsActivityTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum.isSupportApi();
    }

    public static List<Integer> getSupportApiList() {
        return Arrays.stream(values()).filter(AlipayCountCoinsActivityTypeEnum::isSupportApi).map(AlipayCountCoinsActivityTypeEnum::getType).collect(Collectors.toList());
    }
}
