/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String encoder(String url) {
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            log.warn("url encoder error url={}", (Object)url, (Object)e);
            return url;
        }
    }

    public static String decoder(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            log.warn("url decoder error url={}", (Object)url, (Object)e);
            return url;
        }
    }

    public static String appendQueryParam(String url, String ... infos) {
        if (StringUtils.isEmpty((CharSequence)url) || ArrayUtils.isEmpty((Object[])infos)) {
            return url;
        }
        String params = UrlUtils.buildParams(infos);
        if (StringUtils.isBlank((CharSequence)params)) {
            return url;
        }
        if (url.contains("?")) {
            return url + params;
        }
        return url + "?" + params;
    }

    public static String buildParams(String ... infos) {
        if (infos == null || infos.length < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String info : infos) {
            String trimInfo = StringUtils.trim((String)info);
            if (StringUtils.isEmpty((CharSequence)trimInfo)) continue;
            sb.append('&');
            sb.append(trimInfo);
        }
        if (sb.length() < 1) {
            return "";
        }
        return sb.substring(1);
    }
}

