package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeUserConfDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeUserConfDeleteParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeUserConfSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 活动奖品用户配置表
 * @author lizhi
 * @date 2023/11/13 18:31
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeUserConfService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 活动奖品用户配置集合
     */
    List<ActivityPrizeUserConfDto> selectList(ActivityPrizeUserConfSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPrizeUserConfSearchParam param);

    /**
     * 根据奖品ID和用户手机号查询
     * @param activityPrizeId 奖品ID
     * @param userPhone 用户手机号
     * @return 活动奖品用户配置
     */
    ActivityPrizeUserConfDto selectByPrizeAndUser(Long activityPrizeId, String userPhone);

    /**
     * 根据奖品ID和用户手机号查询（包含已删除的）
     * @param activityPrizeId 奖品ID
     * @param userPhone 用户手机号
     * @return 活动奖品用户配置
     */
    ActivityPrizeUserConfDto selectByPrizeAndUserContainDelete(Long activityPrizeId, String userPhone);

    /**
     * 根据用户手机号及活动查询
     *
     * @param userPhone 用户手机号
     * @param activityId 活动ID
     * @return 活动奖品用户配置集合
     */
    List<ActivityPrizeUserConfDto> selectListByUserActivity(String userPhone, Long activityId);

    /**
     * 查询操作人每个奖品添加白名单人数
     *
     * @param operatorType 操作人类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum
     * @param operatorId 操作人ID
     * @param activityPrizeIds 奖品ID结合
     * @return key：奖品ID，value：奖品对应添加人数
     */
    Map<Long, Long> selectOperatorAddNum(Integer operatorType, Long operatorId, List<Long> activityPrizeIds);
    
    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动奖品用户配置
     */
    ActivityPrizeUserConfDto selectById(Long id);

    /**
     * 筛选客户经理添加的某个奖品的白名单
     *
     * @param activityPrizeId 活动奖品id
     * @param operatorType 操作人类型
     * @param operatorId 操作人id
     * @param lastId 分页序号
     * @param pageSize 分页大小
     * @return 奖品白名单
     */
    List<ActivityPrizeUserConfDto> selectPageByPrizeIdAndOpId(Long activityPrizeId, Integer operatorType, Long operatorId, Long lastId, Integer pageSize);

    /**
     * 新增或更新
     * @param dto 奖品白名单
     * @return 主键
     */
    Long saveOrUpdate(ActivityPrizeUserConfDto dto);

    /**
     * 逻辑删除
     * @param param 删除参数
     * @return 影响行数
     */
    int delete(ActivityPrizeUserConfDeleteParam param);
}
