package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动员工信息表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityStaffDto implements Serializable {

    private static final long serialVersionUID = -7961983564257523363L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 员工手机号
     */
    private String staffPhone;
    /**
     * 上传任务id
     */
    private Long taskId;

    /**
     * 客户经理用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 是否限制添加次数，0-不限制，1-限制
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer addLimitType;

    /**
     * 总添加次数
     */
    private Long totalAddNum;

    /**
     * 已添加次数
     */
    private Long addedNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}