package cn.com.duiba.quanyi.center.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author zzy
 * @create 2023/10/17 20:01
 **/
@Getter
@AllArgsConstructor
public enum UserTypeEnum {
    MP_UNIONID(1, "小程序unionId"),
    H5_COUPON_CODE(2, "H5匿名券码用户"),
    OA_OPENID(3, "公众号静默授权openId"),
    CCB_ZJ_HSQ(4, "浙江建行恵省钱对接"),
    CCB_DINGTALK(5, "建行钉钉联合营销钉钉用户"),
    ;
    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据type值解析
     *
     * @param type
     * @return
     */
    public static UserTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (UserTypeEnum typeEnum : values()) {
            if (Objects.equals(type, typeEnum.type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
