package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtOaDto;

/**
 * 用户关联的小程序和公众号
 * @author lizhi
 * @date 2023/5/16 3:34 PM
 */
@AdvancedFeignClient
public interface RemoteUserExtOaService {

    /**
     * 新增或保存
     * @param dto 关联信息
     * @return 执行结果
     */
    int saveOrUpdate(UserExtOaDto dto);

    /**
     * 根据openId查询，redis缓存，变更时清除缓存
     * @param openId 用户openId
     * @return 用户关联信息
     */
    UserExtOaDto selectByOpenIdCache(String openId);

    /**
     * 根据userId 和 oaId 查询，redis缓存
     * @param userId 用户Id
     * @param oaId oaId
     * @return 用户关联信息
     */
    UserExtOaDto selectByUserIdAndOaIdCache(Long userId, Long oaId);

    /**
     * 更新关注状态
     * @param id 主键
     * @param subscribe 关注状态
     * @return  执行结果
     */
    int updateUserSubscribe(Long id, Integer subscribe);
}
