package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeExtDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeExtSearchParam;
import java.util.List;

/**
 * 奖品配置配置扩展表
 * @author kjj mybatis generator 
 * @date 2023-12-18
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeExtService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 奖品配置配置扩展集合
     */
    List<ActivityPrizeExtDto> selectPage(ActivityPrizeExtSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 奖品配置配置扩展集合
     */
    List<ActivityPrizeExtDto> selectNoPage(ActivityPrizeExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPrizeExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 奖品配置配置扩展
     */
    ActivityPrizeExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 奖品配置配置扩展
     * @return 执行结果
     */
    int insert(ActivityPrizeExtDto dto);

    /**
     * 更新
     * @param dto 奖品配置配置扩展
     * @return 影响行数
     */
    int update(ActivityPrizeExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}