package cn.com.duiba.quanyi.center.api.enums.coupon;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动状态
 * CREATED="已创建",
 * PUBLISHING="发布中",
 * PUBLISHED_FAILED="发布失败",
 * GREY="已发布(白名单验证中)",
 * GOING="已发布",
 * PAUSED="已暂停",
 * ENDED="已结束"
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipayActivityStatusEnum {
    CREATED("CREATED", "已创建"),
    PUBLISHING("PUBLISHING", "发布中"),
    PUBLISHED_FAILED("PUBLISHED_FAILED", "发布失败"),
    GREY("GREY", "已发布(白名单验证中)"),
    GOING("GOING", "已发布"),
    PAUSED("PAUSED", "已暂停"),
    ENDED("ENDED", "已结束"),
    ;

    private final String status;

    private final String desc;
}
