package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityExtDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityExtSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 活动配置扩展表
 * @author kjj mybatis generator 
 * @date 2023-12-15
 */
@AdvancedFeignClient
public interface RemoteActivityExtService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动配置扩展集合
     */
    List<ActivityExtDto> selectPage(ActivityExtSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 活动配置扩展集合
     */
    List<ActivityExtDto> selectNoPage(ActivityExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动配置扩展
     */
    ActivityExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动配置扩展
     * @return 执行结果
     */
    int insert(ActivityExtDto dto);

    /**
     * 更新
     * @param dto 活动配置扩展
     * @return 影响行数
     */
    int update(ActivityExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据活动id查询(有缓存)
     * @param activityId 主键
     * @return conf_name conf_value
     */
    Map<Integer, String> queryMapByActivityId(Long activityId);


    /**
     * 根据活动id查询(无缓存)
     * @param activityIds 主键
     * @return map<活动id，map<conf_name，conf_value>>
     */
    Map<Long, Map<Integer, String>> queryMapByActivityIds(List<Long> activityIds);

}