package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.CcbCountCoinsActivityDto;

import cn.com.duiba.quanyi.center.api.param.coupon.CcbCountCoinsActivityPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.CcbCountCoinsActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.CcbCountCoinsBindDemandGoodsParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteCcbCountCoinsActivityService {
    /**
     * 根据主键查询建行数币红包
     *
     * @param id
     * @return
     */
    CcbCountCoinsActivityDto selectById(Long id);

    /**
     * 根据建行数币红包id查询建行数币红包
     *
     * @param activityId 建行数币红包id
     * @return
     */
    CcbCountCoinsActivityDto selectByActId(String activityId);

    /**
     * 根据id批量查询
     *
     * @param idList
     * @return
     */
    Map<Long, CcbCountCoinsActivityDto> selectByIdList(Set<Long> idList);

    /**
     * 根据需求ID查询
     *
     * @param demandId
     * @return
     */
    List<CcbCountCoinsActivityDto> selectByDemandId(Long demandId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandId
     * @param skuId
     * @return
     */
    List<CcbCountCoinsActivityDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<CcbCountCoinsActivityDto> selectPage(CcbCountCoinsActivityPageParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(CcbCountCoinsActivityPageParam param);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(CcbCountCoinsActivitySaveOrUpdateParam param);

    /**
     * 绑定到需求商品
     *
     * @return
     */
    int bindDemandGoods(CcbCountCoinsBindDemandGoodsParam param);

    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<CcbCountCoinsBindDemandGoodsParam> list);

    /**
     * 解除绑定
     *
     * @return
     */
    int unbindDemandGoods(Long id, Long demandGoodsId);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId
     * @return
     */
    List<CcbCountCoinsActivityDto> findByDemandGoodsId(Long demandGoodsId);
}
