package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * API供给
 * @author lizhi
 * @date 2023/12/4 20:31
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiOrderResult extends ApiBaseResult {
    
    private static final long serialVersionUID = 4372430151952159865L;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Long specType;

    /**
     * 主订单号
     */
    private String mainOrderNum;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 券包主订单状态：
     * ● 1：处理中
     * ● 2：全部成功
     * ● 3：全部失败
     */
    private Integer mainOrderStatus;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 券包子订单数据，json数组格式
     */
    private List<ApiQuerySubOrderResult> subOrderDataList;
}
