package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/20 16:02
 */
@Data
public class ApiQuerySubOrderResult implements Serializable {
    
    private static final long serialVersionUID = -4081510886642210993L;

    /**
     * 子订单号
     */
    private String subOrderNum;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 错误码，业务错误码，一般是业务逻辑的错误码
     */
    private String failCode;

    /**
     * 错误描述
     */
    private String failDesc;

    /**
     * 发放类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 商品类型
     * 
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 链接券-短链
     */
    private String shortUrl;
    
}
